/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sandbox;

import com.atlassian.maven.plugins.sandbox.AbstractSandboxMojo;
import com.atlassian.sandbox.model.SandboxRepository;
import com.atlassian.sandbox.model.SandboxResult;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;

public class SandboxMojo
extends AbstractSandboxMojo {
    private static final Gson GSON = new Gson();
    private static final String SANDBOX_RESULT_FILE_NAME = "sandbox.json";
    private ArtifactRepositoryFactory repositoryFactory;
    protected String outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isEnabled()) {
            this.getLog().info((CharSequence)"Sandbox enabled");
            this.setArtifactRepositories();
            SandboxResult sandboxResult = this.createResult();
            this.writeResult(sandboxResult);
        }
    }

    private SandboxResult createResult() throws MojoExecutionException {
        SandboxResult sandboxResult = new SandboxResult();
        ArtifactRepository artifactRepository = this.getProject().getDistributionManagementArtifactRepository();
        SandboxRepository sandboxRepository = new SandboxRepository(artifactRepository.getId(), artifactRepository.getUrl());
        sandboxResult.addRepository(sandboxRepository);
        return sandboxResult;
    }

    private void writeResult(SandboxResult sandboxResult) throws MojoExecutionException {
        File sandboxFile = new File(this.outputDirectory, SANDBOX_RESULT_FILE_NAME);
        if (!sandboxFile.getParentFile().exists()) {
            sandboxFile.getParentFile().mkdirs();
        }
        try {
            FileUtils.writeStringToFile((File)sandboxFile, (String)GSON.toJson((Object)sandboxResult));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write sandbox result for this module to '" + sandboxFile.getAbsolutePath() + "'", (Exception)e);
        }
    }

    private void setArtifactRepositories() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Sandboxing deployment repositories to " + this.getRepositorySandboxUrl()));
        ArtifactRepository releaseRepository = this.createDeployableArtifactRepository(this.getProject().getDistributionManagement().getRepository());
        this.getProject().setReleaseArtifactRepository(releaseRepository);
        ArtifactRepository snapshotRepository = this.createDeployableArtifactRepository(this.getProject().getDistributionManagement().getSnapshotRepository());
        this.getProject().setSnapshotArtifactRepository(snapshotRepository);
    }

    private ArtifactRepository createDeployableArtifactRepository(DeploymentRepository deploymentRepository) throws MojoExecutionException {
        String newDeploymentUrl = !this.getRepositorySandboxUrl().startsWith("dav:") ? "dav:" + this.getRepositorySandboxUrl() + "/" + this.getRepositoryName(deploymentRepository.getUrl()) : this.getRepositorySandboxUrl() + "/" + this.getRepositoryName(deploymentRepository.getUrl());
        this.getLog().info((CharSequence)("Repository " + deploymentRepository.getUrl() + " has been sandboxed to " + newDeploymentUrl));
        return this.repositoryFactory.createDeploymentArtifactRepository(deploymentRepository.getId(), newDeploymentUrl, (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), deploymentRepository.isUniqueVersion());
    }

    public String getRepositoryName(String url) {
        String[] parts = StringUtils.split((String)url, (String)"/");
        if (parts.length > 0) {
            return parts[parts.length - 1];
        }
        return null;
    }
}

