/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sandbox;

import com.atlassian.maven.plugins.sandbox.AbstractSandboxMojo;
import com.atlassian.maven.plugins.sandbox.ScmException;
import com.atlassian.maven.plugins.sandbox.scm.ScmConnectionWrapper;
import com.atlassian.maven.plugins.sandbox.scm.ScmHandler;
import com.atlassian.maven.plugins.sandbox.scm.ScmHandlerFactory;
import com.atlassian.maven.plugins.sandbox.scm.ScmRoHandler;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class ReleaseMojo
extends AbstractSandboxMojo {
    private Prompter prompter;
    private String developmentVersion;
    private String releaseVersion;
    private String extraArguments;
    private String extraPrepareArguments;
    private String extraPerformArguments;
    private String sandboxTagUrl;
    private String releaseTagUrl;
    private ScmHandler scmDevHandler;
    private ScmRoHandler scmReadOnlyHandler;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.scmDevHandler = ScmHandlerFactory.createScmUtils(this.getLog(), this.getProject().getScm().getDeveloperConnection());
        this.scmReadOnlyHandler = ScmHandlerFactory.createScmRoUtils(this.getLog(), this.getProject().getScm().getConnection());
        this.checkSandboxKeySpecified();
        if (this.isPromptAndMetadataStorageRequired()) {
            this.getLog().info((CharSequence)("Staging release at " + this.getRepositorySandboxUrl()));
            this.promptForVersions();
            this.validateReleaseAndDevelopmentVersions();
            this.storeSandboxMetadata();
        } else {
            this.sandboxTagUrl = this.scmReadOnlyHandler.getTagString(this.getTagName());
            this.releaseTagUrl = this.scmReadOnlyHandler.getTagString(this.getProject().getArtifactId() + "-" + this.releaseVersion);
        }
        this.makeSessionNonInteractive();
        MojoExecutor.executeMojo((Plugin)RELEASE_PLUGIN, (String)MojoExecutor.goal((String)"prepare"), (Xpp3Dom)this.getConfigurationForPrepare(), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.getProject(), (MavenSession)this.getSession(), (PluginManager)this.getPluginManager()));
        MojoExecutor.executeMojo((Plugin)RELEASE_PLUGIN, (String)MojoExecutor.goal((String)"perform"), (Xpp3Dom)this.getConfigurationForPerform(), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.getProject(), (MavenSession)this.getSession(), (PluginManager)this.getPluginManager()));
        this.printPostReleaseHelp();
    }

    private boolean isPromptAndMetadataStorageRequired() throws MojoFailureException {
        try {
            DefaultVersionInfo versionInfo = new DefaultVersionInfo(this.getProject().getVersion());
            return versionInfo.isSnapshot();
        }
        catch (VersionParseException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void promptForVersions() throws MojoFailureException {
        if (StringUtils.isEmpty((String)this.releaseVersion) || StringUtils.isEmpty((String)this.developmentVersion)) {
            this.getLog().info((CharSequence)"Press enter to accept defaults");
        }
        try {
            DefaultVersionInfo currentVersionInfo;
            if (StringUtils.isEmpty((String)this.releaseVersion)) {
                currentVersionInfo = new DefaultVersionInfo(this.getProject().getVersion());
                this.releaseVersion = this.prompter.prompt("What is the release version for \"" + this.getProject().getName() + "\"?", currentVersionInfo.getReleaseVersionString());
            }
            if (StringUtils.isEmpty((String)this.developmentVersion)) {
                currentVersionInfo = new DefaultVersionInfo(this.releaseVersion);
                this.developmentVersion = currentVersionInfo.getNextVersion().getSnapshotVersionString();
                this.developmentVersion = this.prompter.prompt("What is the new development version for \"" + this.getProject().getName() + "\"?", this.developmentVersion);
            }
        }
        catch (VersionParseException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (PrompterException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void validateReleaseAndDevelopmentVersions() throws MojoFailureException, MojoExecutionException {
        if (StringUtils.isNotEmpty((String)this.developmentVersion) && !this.developmentVersion.endsWith("-SNAPSHOT")) {
            throw new MojoFailureException("-Dsandbox.developmentVersion should end with -SNAPSHOT");
        }
        if (StringUtils.isNotEmpty((String)this.releaseVersion) && this.releaseVersion.endsWith("-SNAPSHOT")) {
            throw new MojoExecutionException("-Dsandbox.releaseVersion should NOT end with -SNAPSHOT");
        }
    }

    private void storeSandboxMetadata() throws MojoFailureException {
        String branchName;
        this.sandboxTagUrl = this.scmReadOnlyHandler.getTagString(this.getTagName());
        this.releaseTagUrl = this.scmReadOnlyHandler.getTagString(this.getProject().getArtifactId() + "-" + this.releaseVersion);
        this.getLog().info((CharSequence)("Release will be tagged at '" + this.sandboxTagUrl + "'"));
        this.getSandboxService().storeReleaseMetadata(this.getSandboxKey(), this.sandboxTagUrl, this.releaseTagUrl);
        String readOnlyConnection = this.getProject().getScm().getConnection();
        this.setPropertyIfNotBlank("scm.connection", readOnlyConnection);
        String readWriteConnection = this.getProject().getScm().getDeveloperConnection();
        this.setProperty("scm.developerConnection", readWriteConnection);
        this.setProperty("workspace", this.getWorkspace());
        try {
            branchName = this.scmDevHandler.getBranch();
        }
        catch (ScmException e) {
            throw new MojoFailureException("Unable to retrieve branch name", (Throwable)e);
        }
        this.setProperty("branch", branchName);
        this.getLog().info((CharSequence)"Successfully stored the release metadata.");
    }

    String getWorkspace() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "unknown";
        }
        return hostName + ":" + this.getSession().getExecutionRootDirectory();
    }

    private Xpp3Dom getConfigurationForPrepare() {
        StringBuilder sb = new StringBuilder();
        String customSettingsArgument = this.getCustomSettingsArgument();
        if (StringUtils.isNotEmpty((String)customSettingsArgument)) {
            sb.append(" ");
            sb.append(customSettingsArgument);
        }
        if (StringUtils.isNotEmpty((String)this.extraArguments)) {
            sb.append(" ");
            sb.append(this.extraArguments);
        }
        if (StringUtils.isNotEmpty((String)this.extraPrepareArguments)) {
            sb.append(" ");
            sb.append(this.extraPrepareArguments);
        }
        if (StringUtils.isNotEmpty((String)this.developmentVersion) && StringUtils.isNotEmpty((String)this.releaseVersion)) {
            return MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"releaseVersion", (String)this.releaseVersion), MojoExecutor.element((String)"developmentVersion", (String)this.developmentVersion), MojoExecutor.element((String)"tag", (String)this.getTagName()), MojoExecutor.element((String)"arguments", (String)sb.toString())});
        }
        return MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]);
    }

    private Xpp3Dom getConfigurationForPerform() {
        StringBuilder sb = new StringBuilder();
        sb.append(" -Prelease");
        sb.append(" -Dsandbox.sandboxRepositoryUrl=").append(this.getSandboxRepositoryUrl());
        sb.append(" -Dsandbox.key=").append(this.getSandboxKey());
        sb.append(" -Dsandbox.repositoryBaseUrl=").append(this.getMavenRepositoryBaseUrl());
        sb.append(" -Dsandbox.promoterUrl=").append(this.getPromoterUrl());
        String customSettingsArgument = this.getCustomSettingsArgument();
        if (StringUtils.isNotEmpty((String)customSettingsArgument)) {
            sb.append(" ");
            sb.append(customSettingsArgument);
        }
        if (StringUtils.isNotEmpty((String)this.extraPerformArguments)) {
            sb.append(" ");
            sb.append(this.extraPerformArguments);
        }
        if (StringUtils.isNotEmpty((String)this.extraArguments)) {
            sb.append(" ");
            sb.append(this.extraArguments);
        }
        return MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"tag", (String)this.getTagName()), MojoExecutor.element((String)"arguments", (String)sb.toString())});
    }

    private String getTagName() {
        return "sandbox-" + this.getSandboxKey();
    }

    private ScmConnectionWrapper getRepositoryUrl() throws MojoFailureException {
        return new ScmConnectionWrapper(this.getProject().getScm().getConnection());
    }

    private void printPostReleaseHelp() {
        this.printLine();
        this.getLog().info((CharSequence)"Release has been successfully built");
        this.printLine();
        this.printBlankLine();
        this.getLog().info((CharSequence)("Sandbox: " + this.getRepositorySandboxUrl()));
        this.getLog().info((CharSequence)("Sandbox Tag: '" + this.sandboxTagUrl + "'"));
        this.getLog().info((CharSequence)("Release Tag: '" + this.releaseTagUrl + "' (Does not exist until the release is promoted)"));
        this.printBlankLine();
        this.printLine();
        this.getLog().info((CharSequence)"To promote your release (after manual validation) run:");
        this.getLog().info((CharSequence)("\tmvn sandbox:promote -Dsandbox.key=" + this.getSandboxKey()));
        this.printLine();
    }

    private void printLine() {
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
    }

    private void printBlankLine() {
        this.getLog().info((CharSequence)"");
    }
}

