/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sandbox;

import com.atlassian.maven.plugins.sandbox.AbstractSandboxMojo;
import com.atlassian.maven.plugins.sandbox.ScmException;
import com.atlassian.maven.plugins.sandbox.scm.ScmConnectionWrapper;
import com.atlassian.maven.plugins.sandbox.scm.ScmHandler;
import com.atlassian.maven.plugins.sandbox.scm.ScmHandlerFactory;
import com.atlassian.sandbox.promotion.api.SandboxService;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromoteMojo
extends AbstractSandboxMojo {
    private boolean validation;
    private boolean skipTagging;
    private ScmConnectionWrapper developerConnection;
    private ScmHandler scmHandler;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.scmHandler = ScmHandlerFactory.createScmUtils(this.getLog(), this.getProject().getScm().getDeveloperConnection());
        SandboxService sandboxService = this.getSandboxService();
        Server server = this.getServer();
        this.checkSandboxKeySpecified();
        if (this.isAlreadyPromoted()) {
            throw new MojoExecutionException("Sandbox '" + this.getSandboxKey() + "' has already been promoted. To override specify -Dsandbox.validatePromotion=false.");
        }
        if (!this.skipTagging) {
            String developerConnectionString = this.getProperty("scm.developerConnection");
            if (developerConnectionString == null) {
                developerConnectionString = "scm:svn:http://host/path";
            }
            this.developerConnection = new ScmConnectionWrapper(developerConnectionString);
            try {
                this.assertValidWorkspace();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Release cannot be tagged. To override specify -Dsandbox.skipTagging=true.", e);
            }
        }
        String password = this.decryptPasswordIfNecessary(server.getPassword());
        if (!sandboxService.exists(this.getSandboxKey(), server.getUsername(), password, this.getSandboxRepositoryRootUrl())) {
            throw new MojoFailureException("Sandbox '" + this.getSandboxKey() + "' does not exist");
        }
        if (sandboxService.isPromoting(this.getSandboxKey())) {
            throw new MojoExecutionException("Sandbox '" + this.getSandboxKey() + "' is already promoting");
        }
        this.markAsPromoted();
        sandboxService.promote(this.getSandboxKey(), server.getUsername(), password, this.getSandboxRepositoryUrl(), this.getMavenRepositoryBaseUrl());
        this.getLog().info((CharSequence)"Sandbox is promoting...");
        while (sandboxService.isPromoting(this.getSandboxKey())) {
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        this.promotionTasksForSandboxRelease();
        this.getLog().info((CharSequence)"Sandbox has finished promoting");
    }

    private void assertValidWorkspace() throws MojoFailureException, ScmException {
        this.scmHandler.assertValidWorkspace(this.developerConnection.getUrl(), this.getExpectedBranch(), this.getProperty("workspace"));
    }

    private void promotionTasksForSandboxRelease() throws MojoFailureException {
        if (!this.skipTagging) {
            boolean isSandboxRelease;
            Map<String, String> releases = this.getReleasesToSandbox();
            boolean bl = isSandboxRelease = !releases.isEmpty();
            if (isSandboxRelease) {
                this.getLog().info((CharSequence)("Updating tags for " + this.getSandboxKey()));
                this.copySandboxTagsToPromotedTags(releases);
            }
        } else {
            this.getLog().info((CharSequence)"Skipped tag update");
        }
    }

    private void copySandboxTagsToPromotedTags(Map<String, String> sandboxReleases) throws MojoFailureException {
        try {
            for (Map.Entry<String, String> releaseTags : sandboxReleases.entrySet()) {
                this.copySandboxTagToPromotedTag(releaseTags.getKey(), releaseTags.getValue());
            }
        }
        catch (ScmException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void copySandboxTagToPromotedTag(String sandboxTag, String releaseTag) throws MojoFailureException, ScmException {
        String commitMessage = "\"Promoted '" + this.getSandboxKey() + "' from the Sandbox\"";
        this.scmHandler.createRemoteTagAndUpdateToIt(this.developerConnection.getUrl(), sandboxTag, releaseTag, commitMessage);
        this.getLog().info((CharSequence)("Release has been tagged at " + releaseTag));
    }

    private boolean isAlreadyPromoted() throws MojoFailureException {
        return this.validation && this.getProperties().containsKey("promoted");
    }

    private void markAsPromoted() throws MojoFailureException {
        this.setProperty("promoted", "true");
    }

    public String getExpectedBranch() throws MojoFailureException {
        return this.getProperty("branch");
    }
}

