/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sandbox;

import com.atlassian.sandbox.promotion.api.SandboxService;
import com.atlassian.xmlrpc.RedstoneBinder;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.twdata.maven.mojoexecutor.MojoExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSandboxMojo
extends AbstractMojo {
    protected static final Plugin RELEASE_PLUGIN = MojoExecutor.plugin((String)"org.apache.maven.plugins", (String)"maven-release-plugin", (String)"2.1");
    private SandboxService sandboxService;
    private MavenProject project;
    private MavenSession session;
    private PluginManager pluginManager;
    private Settings settings;
    private String serverId;
    private String sandboxRepositoryUrl;
    private String sandboxKey;
    private String repositoryBaseUrl;
    private String promoterUrl;
    private String sandboxSettingsFilename;
    private SecDispatcher secDispatcher;

    protected boolean isEnabled() {
        return StringUtils.isNotEmpty((String)this.getSandboxRepositoryUrl()) && StringUtils.isNotEmpty((String)this.getSandboxKey()) && StringUtils.isNotEmpty((String)this.getMavenRepositoryBaseUrl());
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected MavenSession getSession() {
        return this.session;
    }

    protected PluginManager getPluginManager() {
        return this.pluginManager;
    }

    protected Settings getSettings() {
        return this.settings;
    }

    protected String getSandboxRepositoryRootUrl() {
        if (!StringUtils.isEmpty((String)this.sandboxRepositoryUrl)) {
            return StringUtils.strip((String)this.sandboxRepositoryUrl);
        }
        return this.sandboxRepositoryUrl;
    }

    protected String getRepositorySandboxUrl() {
        String url = this.getSandboxRepositoryRootUrl();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url + this.getSandboxKey() + "/";
    }

    protected String getSandboxRepositoryUrl() {
        return this.sandboxRepositoryUrl;
    }

    protected String getSandboxKey() {
        return this.sandboxKey;
    }

    protected String getMavenRepositoryBaseUrl() {
        return this.repositoryBaseUrl;
    }

    protected String getPromoterUrl() {
        return this.promoterUrl;
    }

    protected Server getServer() {
        return this.settings.getServer(this.serverId);
    }

    protected String getSandboxSettingsFilename() {
        return this.sandboxSettingsFilename;
    }

    protected void setProperty(String propertyKey, String propertyValue) throws MojoFailureException {
        this.getSandboxService().setProperty(this.getSandboxKey(), propertyKey, propertyValue);
    }

    protected String getProperty(String propertyKey) throws MojoFailureException {
        return this.getProperties().get(propertyKey);
    }

    protected void setPropertyIfNotBlank(String propertyKey, String propertyValue) throws MojoFailureException {
        if (propertyValue != null && !propertyValue.trim().isEmpty()) {
            this.getSandboxService().setProperty(this.getSandboxKey(), propertyKey, propertyValue);
        }
    }

    protected Map<String, String> getProperties() throws MojoFailureException {
        return this.getSandboxService().getProperties(this.sandboxKey);
    }

    protected String getCustomSettingsArgument() {
        StringBuilder sb = new StringBuilder();
        if (this.sandboxSettingsFilename == null) {
            return sb.toString();
        }
        File settingsPath = new File(this.sandboxSettingsFilename);
        if (settingsPath.exists()) {
            sb.append("-s ");
            sb.append(settingsPath.getAbsolutePath());
        }
        return sb.toString();
    }

    protected SandboxService getSandboxService() throws MojoFailureException {
        if (this.sandboxService == null) {
            try {
                this.getLog().info((CharSequence)("Connecting to promoter service at " + this.promoterUrl));
                this.sandboxService = (SandboxService)new RedstoneBinder().bind(SandboxService.class, new URL(this.promoterUrl));
            }
            catch (Exception e) {
                throw new MojoFailureException("Could not bind to Sandbox promoter service: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.sandboxService;
    }

    protected void checkSandboxKeySpecified() throws MojoFailureException {
        if (StringUtils.isEmpty((String)this.getSandboxKey())) {
            throw new MojoFailureException("-Dsandbox.key was not specified or was empty");
        }
    }

    protected void makeSessionNonInteractive() {
        this.settings.setInteractiveMode(false);
    }

    protected Map<String, String> getReleasesToSandbox() throws MojoFailureException {
        SandboxService sandboxService = this.getSandboxService();
        return sandboxService.getReleasesInSandbox(this.sandboxKey);
    }

    protected String decryptPasswordIfNecessary(String password) {
        if (this.secDispatcher != null) {
            try {
                password = this.secDispatcher.decrypt(password);
            }
            catch (SecDispatcherException e) {
                this.getLog().error((CharSequence)"SecDispatcher error decrypting password.");
            }
        } else {
            this.getLog().info((CharSequence)"Could not find SecDispatcher, won't be able to decrypt passwords.");
        }
        return password;
    }
}

