package com.atlassian.maven.plugins.sandbox.scm;

import com.atlassian.maven.plugins.sandbox.ScmException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvnHandler implements ScmHandler
{
    private final Log log;
    private final String connection;
    private final ScmConnectionWrapper connectionWrapper;

    public SvnHandler(final Log log, @NotNull final String connection) throws MojoFailureException
    {
        this.log = log;
        this.connection = connection;
        this.connectionWrapper = new ScmConnectionWrapper(connection);
    }

    @NotNull
    public String getBranch() throws ScmException
    {
        return connection;
    }

    public void assertValidWorkspace(final String urlWeWantToPushTo, final String expectedBranch, final String originalWorkspace)
    {
        //always valid, we do everything remotely
    }

    public void createRemoteTagAndUpdateToIt(final String destinationUrl, final String revisionToTag, final String tagName, final String commitMessage) throws ScmException
    {
        final int exitCode;
        if ((exitCode = SvnUtil.tag(log, revisionToTag, tagName, commitMessage)) != 0)
        {
            log.error("Release could not be tagged. Code: " + exitCode);
        }
    }

    @Nullable
    public String getTagString(final String tagName)
    {
        return SvnUtil.resolveTagUrl(connectionWrapper.getUrl(), tagName);
    }
}
