package com.atlassian.maven.plugins.sandbox.scm;

import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.Nullable;

public class ScmHandlerFactory
{
    private ScmHandlerFactory()
    {
    }

    @Nullable
    public static ScmHandler createScmUtils(final Log log, @Nullable final String connection) throws MojoFailureException
    {
        if (connection==null)
        {
            //repo interaction was disabled
            return null;
        }
        final ScmConnectionWrapper wrapper = new ScmConnectionWrapper(connection);
        switch (wrapper.getRepositoryType())
        {
            case ScmConnectionWrapper.RepositoryType.SVN:
                return new SvnHandler(log, connection);
            case ScmConnectionWrapper.RepositoryType.HG:
                return new HgHandler(log);
            case ScmConnectionWrapper.RepositoryType.GIT:
                return new GitHandler(log);
            default:
                throw new MojoFailureException("Unknown repository type " + connection);
        }
    }

    @Nullable
    public static ScmRoHandler createScmRoUtils(final Log log, @Nullable final String connection) throws MojoFailureException
    {
        return createScmUtils(log, connection);
    }
}
