package com.atlassian.maven.plugins.sandbox.scm;


import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;

public class ScmConnectionWrapper
{
    protected static final String SCM_SVN_PREFIX = "scm:svn:";
    protected static final String SCM_HG_PREFIX = "scm:hg:";
    protected static final String SCM_GIT_PREFIX = "scm:git:";

    private final String url;
    private final int repositoryType;


    public ScmConnectionWrapper(final String connection) throws MojoFailureException
    {
        if (isSvnConnection(connection))
        {
            this.url = StringUtils.replace(connection, SCM_SVN_PREFIX, "");
            repositoryType = RepositoryType.SVN;
        }
        else if (isMercurialConnection(connection))
        {
            this.url = StringUtils.replace(connection, SCM_HG_PREFIX, "");
            repositoryType = RepositoryType.HG;
        }
        else if (isGitConnection(connection))
        {
            this.url = StringUtils.replace(connection, SCM_GIT_PREFIX, "");
            repositoryType = RepositoryType.GIT;
        }
        else
        {
            throw new MojoFailureException("Repository '" + connection + "' is not a supported SCM system");
        }
    }

    public static boolean isSvnConnection(final String url)
    {
        return url.startsWith(SCM_SVN_PREFIX);
    }

    public static boolean isMercurialConnection(final String url)
    {
        return url.startsWith(SCM_HG_PREFIX);
    }

    public static boolean isGitConnection(final String url)
    {
        return url.startsWith(SCM_GIT_PREFIX);
    }

    //mojo parser does not like enums
    static class RepositoryType
    {
        public static final int HG = 1;
        public static final int SVN = 2;
        public static final int GIT = 3;

        private RepositoryType()
        {
        }
    }

    public String getUrl()
    {
        return url;
    }

    int getRepositoryType()
    {
        return repositoryType;
    }

    @Override
    public String toString()
    {
        return url;
    }
}
