/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.repository.utils.DigestUtils;
import org.codehaus.plexus.util.FileUtils;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

@MojoGoal(value="bundle")
public class BundleMojo
extends AbstractMojo {
    private static final ArtifactRepositoryLayout LAYOUT = new DefaultRepositoryLayout();
    @MojoParameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @MojoParameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @MojoParameter(defaultValue="${project.build.directory}/repository")
    private File repositoryDirectory;
    @MojoParameter
    private List<String> artifacts;
    @MojoComponent
    private ArtifactResolver artifactResolver;
    @MojoComponent
    private ArtifactMetadataSource metadataSource;
    @MojoComponent
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @MojoComponent
    private ArtifactFactory artifactFactory;
    @MojoComponent
    private MavenProjectBuilder projectBuilder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.artifacts.isEmpty()) {
            ArtifactRepository targetRepository = this.createLocalRepository(this.repositoryDirectory);
            for (String artifact : this.artifacts) {
                this.addArtifactToRepository(this.toArtifact(artifact), targetRepository);
            }
        } else {
            this.getLog().info((CharSequence)"No artifacts defined, won't do shit!");
        }
    }

    private Artifact toArtifact(String artifact) throws MojoFailureException {
        String[] artifactElements = artifact.split(":");
        if (artifactElements.length != 4 && artifactElements.length != 3) {
            throw new MojoFailureException("Artifact " + artifact + " is ill defined. Please use format groupId:artifactId:version[:type]");
        }
        String groupId = artifactElements[0];
        String artifactId = artifactElements[1];
        String version = artifactElements[2];
        String type = artifactElements.length == 4 ? artifactElements[3] : "jar";
        return this.artifactFactory.createArtifact(groupId, artifactId, version, "compile", type);
    }

    private void addArtifactToRepository(Artifact artifact, ArtifactRepository targetRepository) throws MojoExecutionException {
        try {
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(Collections.singleton(artifact), this.project.getArtifact(), null, this.localRepository, this.project.getRemoteArtifactRepositories(), this.metadataSource);
            for (Artifact a : result.getArtifacts()) {
                this.getLog().debug((CharSequence)("Re-resolving: " + a + " for repository assembly."));
                a.setResolved(false);
                this.artifactResolver.resolve(a, this.project.getRemoteArtifactRepositories(), this.localRepository);
                a.setVersion(a.getBaseVersion());
                File targetFile = new File(targetRepository.getBasedir(), targetRepository.pathOf(a));
                FileUtils.copyFile((File)a.getFile(), (File)targetFile);
                this.writeChecksums(targetFile);
                this.addPomWithAncestry(a, this.project.getRemoteArtifactRepositories(), this.localRepository, targetRepository, this.project);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected ArtifactRepository createLocalRepository(File directory) {
        String localRepositoryUrl = directory.getAbsolutePath();
        if (!localRepositoryUrl.startsWith("file:")) {
            localRepositoryUrl = "file://" + localRepositoryUrl;
        }
        return this.createRepository("local", localRepositoryUrl, false, true, "warn");
    }

    public ArtifactRepository createRepository(String repositoryId, String repositoryUrl, boolean offline, boolean updateSnapshots, String globalChecksumPolicy) {
        DefaultArtifactRepository localRepository = new DefaultArtifactRepository(repositoryId, repositoryUrl, LAYOUT);
        boolean snapshotPolicySet = false;
        if (offline) {
            snapshotPolicySet = true;
        }
        if (!snapshotPolicySet && updateSnapshots) {
            this.artifactRepositoryFactory.setGlobalUpdatePolicy("always");
        }
        this.artifactRepositoryFactory.setGlobalChecksumPolicy(globalChecksumPolicy);
        return localRepository;
    }

    private void addPomWithAncestry(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository, ArtifactRepository targetRepository, MavenProject masterProject) {
        MavenProject p;
        String type = artifact.getType();
        Map refs = masterProject.getProjectReferences();
        String projectKey = ArtifactUtils.versionlessKey((Artifact)artifact);
        if (artifact == masterProject.getArtifact()) {
            p = masterProject;
        } else if (refs.containsKey(projectKey)) {
            p = (MavenProject)refs.get(projectKey);
        } else {
            try {
                artifact.isSnapshot();
                Artifact pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
                this.getLog().debug((CharSequence)("Building MavenProject instance for: " + pomArtifact + ". NOTE: This SHOULD BE available in the Artifact API! ...but it's not."));
                p = this.projectBuilder.buildFromRepository(pomArtifact, remoteArtifactRepositories, localRepository);
            }
            catch (ProjectBuildingException e) {
                throw new RuntimeException("Error reading POM for: " + artifact.getId(), e);
            }
        }
        if ("pom".equals(type)) {
            p = p.getParent();
        }
        while (p != null) {
            Artifact destArtifact = this.artifactFactory.createProjectArtifact(p.getGroupId(), p.getArtifactId(), p.getVersion());
            File sourceFile = p.getFile();
            if (sourceFile == null || !sourceFile.exists()) {
                Artifact srcArtifact = this.artifactFactory.createProjectArtifact(p.getGroupId(), p.getArtifactId(), p.getVersion());
                sourceFile = new File(localRepository.getBasedir(), localRepository.pathOf(srcArtifact));
            }
            if (!sourceFile.exists()) break;
            File targetFile = new File(targetRepository.getBasedir(), targetRepository.pathOf(destArtifact));
            try {
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing POM metdata: " + destArtifact.getId(), e);
            }
            try {
                this.writeChecksums(targetFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing checksums for POM: " + destArtifact.getId(), e);
            }
            p = p.getParent();
        }
    }

    private void writeChecksums(File file) throws IOException {
        try {
            String md5 = DigestUtils.createChecksum((File)file, (String)"MD5");
            String sha1 = DigestUtils.createChecksum((File)file, (String)"SHA-1");
            FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".md5").getAbsolutePath(), (String)md5.toLowerCase());
            FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".sha1").getAbsolutePath(), (String)sha1.toLowerCase());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to get write checksums: " + e.getMessage(), e);
        }
    }
}

