/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws.scm;

import com.atlassian.bamboo.maven.plugins.aws.scm.GitUtils;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.Nullable;

public class ScmUtils {
    private static final Logger log = Logger.getLogger(ScmUtils.class);

    private ScmUtils() {
    }

    public static String getId(Log log) {
        return GitUtils.getId(log);
    }

    static int runScm(@Nullable Log log, Collection<String> output, String cmd, String ... arguments) {
        String command = null;
        try {
            List<String> argList = Arrays.asList(arguments);
            LinkedList<String> commandList = new LinkedList<String>();
            commandList.add(cmd);
            commandList.addAll(argList);
            ProcessBuilder processBuilder = new ProcessBuilder(commandList);
            processBuilder.redirectErrorStream(true);
            command = StringUtils.join(processBuilder.command(), (char)' ');
            if (log != null) {
                log.info((CharSequence)("Running command: '" + command + "'."));
            }
            Process process = processBuilder.start();
            List processOutput = IOUtils.readLines((InputStream)process.getInputStream());
            output.clear();
            output.addAll(processOutput);
            return process.waitFor();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("An error has occured when running hg command: " + command, e);
        }
    }

    public static void main(String[] args) {
        System.out.println(ScmUtils.getId(null));
    }
}

