/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import com.atlassian.bamboo.maven.plugins.aws.AbstractImageRebuildMojo;
import com.atlassian.bamboo.maven.plugins.aws.DecoratingLog;
import com.atlassian.bamboo.maven.plugins.aws.Ec2InstanceIdFile;
import com.atlassian.bamboo.maven.plugins.aws.InputStreamConsumer;
import com.atlassian.bamboo.maven.plugins.aws.files.FileTools;
import com.google.common.collect.Lists;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;

public class Ec2SshMojo
extends AbstractImageRebuildMojo {
    private File ec2InstanceIDFile;
    private String ec2KeyName;
    private File ec2PrivateKeyFile;
    private String user;
    private String[] files;
    private String destination;
    private String command;

    private static void sleep() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void executeMojo() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        JSch jSch = new JSch();
        this.ec2PrivateKeyFile = FileTools.defaultPrivateKeyFile(this.ec2PrivateKeyFile, this.ec2KeyName, this.project);
        log.info((CharSequence)("Using private key file " + this.ec2PrivateKeyFile));
        try {
            jSch.addIdentity(this.ec2PrivateKeyFile.toString());
        }
        catch (JSchException exception) {
            throw new MojoExecutionException("Private key file " + this.ec2PrivateKeyFile + " is invalid.", (Exception)((Object)exception));
        }
        ArrayList instanceIds = new Ec2InstanceIdFile(this.ec2InstanceIDFile).read();
        ArrayList threads = Lists.newArrayList();
        log.info((CharSequence)("Waiting for the following instances to come up: " + instanceIds));
        while (!instanceIds.isEmpty()) {
            List reservations;
            ArrayList pendingInstanceIds = Lists.newArrayList();
            try {
                reservations = this.describeInstances(instanceIds).getReservations();
            }
            catch (AmazonServiceException exception) {
                throw new MojoExecutionException("Could not get instance descriptions.", (Exception)((Object)exception));
            }
            for (Reservation reservation : reservations) {
                List instances = reservation.getInstances();
                for (Instance instance : instances) {
                    if (StringUtils.isBlank((String)instance.getPublicDnsName())) {
                        pendingInstanceIds.add(instance.getInstanceId());
                        continue;
                    }
                    threads.add(this.launchImageCreationThread(log, instance, jSch));
                }
            }
            instanceIds = pendingInstanceIds;
            if (instanceIds.isEmpty()) continue;
            Ec2SshMojo.sleep();
        }
        log.info((CharSequence)"Customisation of all instances has started.");
        for (ImageCustomisationThread thread : threads) {
            try {
                thread.join();
                Exception exception = thread.getException();
                if (exception == null) continue;
                throw new MojoExecutionException("Instance customisation failed", exception);
            }
            catch (InterruptedException e) {
                throw new MojoFailureException("An error has occured while wainting for cusotmisation threads to finish", (Throwable)e);
            }
        }
        log.info((CharSequence)"Customisation of all instances has finished.");
        log.info((CharSequence)"---------------------------------");
        log.info((CharSequence)"---------------------------------");
        log.info((CharSequence)"---------------------------------");
    }

    private ImageCustomisationThread launchImageCreationThread(Log log, Instance instance, JSch jSch) {
        ImageCustomisationThread thread = new ImageCustomisationThread(log, instance, jSch);
        thread.start();
        return thread;
    }

    private static String getDecoration(Instance instance) {
        return instance.getImageId() + "." + instance.getRootDeviceType() + "." + instance.getArchitecture();
    }

    private static class ProgressMonitor
    implements SftpProgressMonitor {
        private final Log log;
        private long max;
        private long lastProgressIn10s = -1L;
        private long transferredSoFar = 0L;

        public ProgressMonitor(Log log) {
            this.log = log;
        }

        public void init(int op, String src, String dest, long max) {
            this.max = max;
            String opString = op == 0 ? "Sending" : "Fetching";
            this.log.info((CharSequence)(opString + " " + src + " to " + dest + ", transfer size: " + FileUtils.byteCountToDisplaySize((int)((int)max))));
        }

        public boolean count(long count) {
            this.transferredSoFar += count;
            long progressPercentage = this.transferredSoFar * 100L / this.max;
            long progressIn10s = progressPercentage / 10L;
            if (progressIn10s != this.lastProgressIn10s) {
                this.lastProgressIn10s = progressIn10s;
                if (this.transferredSoFar != this.max) {
                    this.log.info((CharSequence)(progressPercentage + "% transferred, " + FileUtils.byteCountToDisplaySize((int)((int)(this.max - this.transferredSoFar))) + " remaining..."));
                }
            }
            return true;
        }

        public void end() {
            this.log.info((CharSequence)"Transfer completed.");
        }
    }

    private class ImageCustomisationThread
    extends Thread {
        private final Log log;
        private final String instanceAddress;
        private final JSch jSch;
        private Exception exception;

        public ImageCustomisationThread(Log log, Instance instance, JSch jSch) {
            this.log = new DecoratingLog(log, Ec2SshMojo.getDecoration(instance));
            this.instanceAddress = instance.getPublicDnsName();
            this.jSch = jSch;
        }

        @Override
        public void run() {
            try {
                this.runSession(this.jSch, this.instanceAddress);
            }
            catch (Exception e) {
                this.exception = e;
                this.log.error((CharSequence)"", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runSession(JSch jSch, String host) throws MojoExecutionException, MojoFailureException {
            this.log.info((CharSequence)("Opening session to " + Ec2SshMojo.this.user + "@" + host));
            Properties properties = new Properties();
            properties.setProperty("StrictHostKeyChecking", "no");
            try {
                Session session = this.openSession(jSch, host, properties);
                try {
                    this.putFiles(session, this.log);
                    this.executeCommand(session, this.log);
                }
                finally {
                    session.disconnect();
                }
            }
            catch (MojoFailureException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new MojoExecutionException("Connection to " + host + " failed.", exception);
            }
        }

        private Session openSession(JSch jSch, String host, Properties properties) throws JSchException {
            int retry = 0;
            while (true) {
                try {
                    Session session = jSch.getSession(Ec2SshMojo.this.user, host);
                    session.setConfig(properties);
                    session.connect(10000);
                    return session;
                }
                catch (JSchException exception) {
                    this.log.debug((Throwable)exception);
                    int maxRetries = 60;
                    if (retry >= 60) {
                        this.log.error((CharSequence)("Unable to open SSH session after " + retry + " attempts"));
                        throw exception;
                    }
                    Ec2SshMojo.sleep();
                    ++retry;
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void putFiles(Session session, Log log) throws JSchException, SftpException {
            if (Ec2SshMojo.this.files != null && Ec2SshMojo.this.files.length > 0) {
                File basedir = Ec2SshMojo.this.project.getBasedir();
                ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
                channel.connect();
                try {
                    for (String file : Ec2SshMojo.this.files) {
                        String absoluteFile = new File(file).isAbsolute() ? file : new File(basedir, file).getAbsolutePath();
                        String validDestination = Ec2SshMojo.this.destination == null ? "." : Ec2SshMojo.this.destination;
                        channel.put(absoluteFile, validDestination, (SftpProgressMonitor)new ProgressMonitor(log));
                    }
                }
                finally {
                    channel.disconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeCommand(Session session, Log log) throws Exception {
            if (Ec2SshMojo.this.command != null) {
                InputStreamConsumer errorStreamConsumer;
                InputStreamConsumer inputStreamConsumer;
                log.info((CharSequence)("Executing " + Ec2SshMojo.this.command));
                ChannelExec channel = (ChannelExec)session.openChannel("exec");
                channel.setCommand(Ec2SshMojo.this.command);
                channel.connect();
                try {
                    inputStreamConsumer = new InputStreamConsumer(channel.getInputStream(), log, false);
                    errorStreamConsumer = new InputStreamConsumer(channel.getErrStream(), log, true);
                    Thread inputThread = new Thread(inputStreamConsumer);
                    Thread errorThread = new Thread(errorStreamConsumer);
                    inputThread.start();
                    errorThread.start();
                    inputThread.join();
                    errorThread.join();
                }
                finally {
                    channel.disconnect();
                }
                inputStreamConsumer.check();
                errorStreamConsumer.check();
                int exitStatus = channel.getExitStatus();
                if (exitStatus != 0) {
                    throw new MojoFailureException("Exit status was non-zero: " + exitStatus);
                }
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

