/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.atlassian.bamboo.maven.plugins.aws.AbstractAwsMojo;
import com.atlassian.bamboo.maven.plugins.aws.Ec2InstanceIdFile;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class Ec2KillMojo
extends AbstractAwsMojo {
    private File ec2InstanceIDFile;

    public void execute() throws MojoExecutionException {
        List<String> instanceIds = new Ec2InstanceIdFile(this.ec2InstanceIDFile).read();
        try {
            TerminateInstancesRequest terminateInstacesRe = new TerminateInstancesRequest(instanceIds);
            this.getAwsEc2Client().terminateInstances(terminateInstacesRe);
        }
        catch (AmazonClientException exception) {
            throw new MojoExecutionException("Could not terminate instances.", (Exception)((Object)exception));
        }
        for (String instanceId : instanceIds) {
            this.getLog().info((CharSequence)("Instance " + instanceId + " terminating."));
        }
    }
}

