/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.atlassian.bamboo.maven.plugins.aws.files.Consumer;
import com.atlassian.bamboo.maven.plugins.aws.files.FileTools;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

class Ec2InstanceIdFile {
    private static final String SEPARATOR = "\n";
    private final File file;

    Ec2InstanceIdFile(File file) {
        this.file = file;
    }

    List<String> read() throws MojoExecutionException {
        if (this.file == null || !this.file.exists()) {
            return Collections.emptyList();
        }
        final ArrayList<String> instanceIds = new ArrayList<String>();
        Consumer consumer = new Consumer(){

            @Override
            public void consume(Reader reader) throws IOException {
                int character;
                StringBuilder instanceId = new StringBuilder();
                int separatorIndex = 0;
                while ((character = reader.read()) >= 0) {
                    if (character == Ec2InstanceIdFile.SEPARATOR.charAt(separatorIndex)) {
                        if (++separatorIndex < Ec2InstanceIdFile.SEPARATOR.length()) continue;
                        instanceIds.add(instanceId.toString());
                        instanceId.setLength(0);
                        separatorIndex = 0;
                        continue;
                    }
                    instanceId.append((char)character);
                }
                instanceId.append(Ec2InstanceIdFile.SEPARATOR, 0, separatorIndex);
                if (instanceId.length() > 0) {
                    instanceIds.add(instanceId.toString());
                }
            }
        };
        try {
            FileTools.read(this.file, consumer);
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Could not read instance ID file.", (Exception)exception);
        }
        return instanceIds;
    }
}

