/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.services.ec2.model.KeyPair;
import com.atlassian.bamboo.maven.plugins.aws.AbstractAwsMojo;
import com.atlassian.bamboo.maven.plugins.aws.files.FileTools;
import com.atlassian.bamboo.maven.plugins.aws.files.Generator;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class Ec2AddKey
extends AbstractAwsMojo {
    private String ec2KeyName;
    private File ec2PrivateKeyFile;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        this.ec2PrivateKeyFile = FileTools.defaultPrivateKeyFile(this.ec2PrivateKeyFile, this.ec2KeyName, this.project);
        if (this.ec2PrivateKeyFile.exists()) {
            log.warn((CharSequence)("Private key file " + this.ec2PrivateKeyFile + " already exists.  Skipping key pair generation."));
        } else {
            KeyPair keyPair;
            try {
                CreateKeyPairRequest createKeyPairRequest = new CreateKeyPairRequest(this.ec2KeyName);
                keyPair = this.getAwsEc2Client().createKeyPair(createKeyPairRequest).getKeyPair();
            }
            catch (AmazonClientException exception) {
                throw new MojoExecutionException("Could not create key pair.", (Exception)((Object)exception));
            }
            log.info((CharSequence)("Key pair " + this.ec2KeyName + " created."));
            FileTools.createParentFiles(this.ec2PrivateKeyFile);
            Generator generator = new Generator(){

                @Override
                public void generate(Writer writer) throws IOException {
                    writer.write(keyPair.getKeyMaterial());
                }
            };
            try {
                FileTools.write(this.ec2PrivateKeyFile, generator);
            }
            catch (IOException exception) {
                throw new MojoExecutionException("Could not write private key file.", (Exception)exception);
            }
            log.info((CharSequence)("Private key written to " + this.ec2PrivateKeyFile));
        }
    }
}

