/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws.files;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class IpRangesFileDao {
    private static final String IP_CIDR_BLOCK_REGEX = "\\d+\\.\\d+\\.\\d+\\.\\d+/\\d+";
    private static final Pattern IP_CIDR_BLOCK_PATTERN = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+/\\d+");

    private IpRangesFileDao() {
    }

    public static Map<AwsSupportConstants.Region, Iterable<String>> read(Log log, String ipRangeFile) throws IOException {
        HashMap regionIpBlocks = Maps.newHashMap();
        List policyLines = FileUtils.readLines((File)new File(ipRangeFile));
        ArrayList ipCidrBlocksForRegion = Lists.newArrayList();
        for (String policyLine : policyLines) {
            if (!StringUtils.isNotBlank((String)policyLine)) continue;
            List<String> rangesFromLine = IpRangesFileDao.getIpRanges(policyLine);
            if (rangesFromLine.isEmpty()) {
                ipCidrBlocksForRegion = Lists.newArrayList();
                AwsSupportConstants.Region region = IpRangesFileDao.translateToNormalisedRegionCode(policyLine);
                regionIpBlocks.put(region, ipCidrBlocksForRegion);
                continue;
            }
            ipCidrBlocksForRegion.addAll(rangesFromLine);
        }
        for (AwsSupportConstants.Region region : AwsSupportConstants.Region.values()) {
            if (region == AwsSupportConstants.Region.CUSTOM) continue;
            Iterable ipBlocks = (Iterable)regionIpBlocks.get(region);
            if (ipBlocks == null) {
                throw new IllegalArgumentException("IP CIDR block definitions are missing for " + region);
            }
            log.info((CharSequence)(region + " : " + ipBlocks));
        }
        return regionIpBlocks;
    }

    private static AwsSupportConstants.Region translateToNormalisedRegionCode(String regionName) {
        ImmutableMap nameToRegion = ImmutableMap.builder().put((Object)".*us.*east.*", (Object)AwsSupportConstants.Region.US_EAST_1).put((Object)".*us.*west.*california.*", (Object)AwsSupportConstants.Region.US_WEST_1).put((Object)".*us.*west.*oregon.*", (Object)AwsSupportConstants.Region.US_WEST_2).put((Object)".*singapore.*", (Object)AwsSupportConstants.Region.ASIA_PACIFIC_SE_1).put((Object)".*sydney.*", (Object)AwsSupportConstants.Region.ASIA_PACIFIC_SE_2).put((Object)".*tokyo.*", (Object)AwsSupportConstants.Region.ASIA_PACIFIC_NE_1).put((Object)".*eu.*", (Object)AwsSupportConstants.Region.EU_WEST_1).put((Object)".*sao.*paulo.*", (Object)AwsSupportConstants.Region.SOUTH_AMERICA_1).build();
        for (Map.Entry stringRegionEntry : nameToRegion.entrySet()) {
            if (!regionName.toLowerCase().matches((String)stringRegionEntry.getKey())) continue;
            return (AwsSupportConstants.Region)stringRegionEntry.getValue();
        }
        throw new IllegalArgumentException("Unknown region name: " + regionName + ", it does not match any of the known regions: " + nameToRegion.keySet());
    }

    @NotNull
    private static List<String> getIpRanges(String policyLine) {
        Matcher matcher = IP_CIDR_BLOCK_PATTERN.matcher(policyLine);
        ArrayList ipCidrBlock = Lists.newArrayList();
        while (matcher.find()) {
            ipCidrBlock.add(matcher.group());
        }
        return ipCidrBlock;
    }
}

