/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.services.s3.AmazonS3;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.configuration.ImageData;
import com.atlassian.bamboo.maven.plugins.aws.AbstractAwsMojo;
import com.atlassian.bamboo.maven.plugins.aws.files.IpRangesFileDao;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;

public class SetupBucketsMojo
extends AbstractAwsMojo {
    private static final String USER_PUBLIC_AGENT_ASSEMBLY_ACCESS = "121852097033:user/PublicAgentAssemblyAccess";
    private String[] regionalisedBuckets;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map<AwsSupportConstants.Region, Iterable<String>> ipCidrBlocksForRegions;
        try {
            ipCidrBlocksForRegions = IpRangesFileDao.read(this.getLog(), "src/main/aws-ip-ranges.txt");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read IP ranges file", (Exception)e);
        }
        for (Map.Entry regionEntry : AwsSupportConstants.LOCATION_CONSTRAINT_TO_REGION.entrySet()) {
            String awsRegionName = (String)regionEntry.getKey();
            AwsSupportConstants.Region region = (AwsSupportConstants.Region)regionEntry.getValue();
            this.getLog().info((CharSequence)("=== Setting up buckets for " + region + ", location constraint: " + awsRegionName + " ==="));
            for (String regionalisedBucketStem : this.regionalisedBuckets) {
                this.setupBucket(regionalisedBucketStem, ipCidrBlocksForRegions.get(region), awsRegionName, region);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupBucket(String agentAssemblyBucketStem, Iterable<String> ipCidrBlocks, String awsRegionName, AwsSupportConstants.Region region) throws MojoExecutionException {
        String bucketNameForRegion = ImageData.getNameForRegion((String)agentAssemblyBucketStem, (AwsSupportConstants.Region)region);
        AmazonS3 s3client = (AmazonS3)this.awsS3Client.get();
        this.getLog().debug((CharSequence)("Checking for existence of " + bucketNameForRegion));
        if (s3client.doesBucketExist(bucketNameForRegion)) {
            String bucketLocation = s3client.getBucketLocation(bucketNameForRegion);
            if (!bucketLocation.equals(awsRegionName)) throw new MojoExecutionException("Bucket " + bucketNameForRegion + " already exists, but not in the expected location. Please recreate it in a correct location: " + awsRegionName);
            this.getLog().debug((CharSequence)("Bucket " + bucketNameForRegion + " is already available in the proper location."));
        } else {
            this.getLog().info((CharSequence)("Creting bucket for region " + bucketNameForRegion));
            if (awsRegionName.equals("US")) {
                awsRegionName = null;
            }
            s3client.createBucket(bucketNameForRegion, awsRegionName);
        }
        this.getLog().info((CharSequence)("Setting up policy for bucket " + bucketNameForRegion));
        String policyText = this.generatePolicy(bucketNameForRegion, ipCidrBlocks);
        this.getLog().debug((CharSequence)policyText);
        s3client.setBucketPolicy(bucketNameForRegion, policyText);
    }

    private String generatePolicy(String bucketNameForRegion, Iterable<String> ipCidrBlocks) {
        String ipCidrBlocksList = "[\"" + StringUtils.join(ipCidrBlocks.iterator(), (String)"\", \"") + "\"]";
        String policy = "{\n  \"Statement\": [\n    {\n      \"Effect\": \"Deny\",\n      \"Principal\": {\n        \"AWS\": \"arn:aws:iam::121852097033:user/PublicAgentAssemblyAccess\"\n      },\n      \"Action\": [\n        \"s3:*\"\n      ],\n      \"Resource\": \"arn:aws:s3:::" + bucketNameForRegion + "\",\n" + "      \"Condition\": {\n" + "        \"NotIpAddress\": {\n" + "          \"aws:SourceIp\": " + ipCidrBlocksList + "\n" + "        }\n" + "      }\n" + "    },\n" + "    {\n" + "      \"Sid\": \"\",\n" + "      \"Effect\": \"Allow\",\n" + "      \"Principal\": {\n" + "        \"AWS\": \"arn:aws:iam::" + USER_PUBLIC_AGENT_ASSEMBLY_ACCESS + "\"\n" + "      },\n" + "      \"Action\": \"s3:ListBucket\",\n" + "      \"Resource\": \"arn:aws:s3:::" + bucketNameForRegion + "\"\n" + "    },\n" + "    {\n" + "      \"Sid\": \"\",\n" + "      \"Effect\": \"Allow\",\n" + "      \"Principal\": {\n" + "        \"AWS\": \"arn:aws:iam::" + USER_PUBLIC_AGENT_ASSEMBLY_ACCESS + "\"\n" + "      },\n" + "      \"Action\": \"s3:GetObject\",\n" + "      \"Resource\": \"arn:aws:s3:::" + bucketNameForRegion + "/*\"\n" + "    }\n" + "  ]\n" + "}";
        return policy;
    }
}

