/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class S3Utils {
    private S3Utils() {
    }

    public static Map<String, String> getObjectNamesAndHashes(AmazonS3 s3client, String bucket, String key) {
        ObjectListing objectListing = s3client.listObjects(bucket, key);
        HashMap name2md5 = Maps.newHashMap();
        S3Utils.fillMd5Map(name2md5, objectListing);
        while (objectListing.isTruncated()) {
            objectListing = s3client.listNextBatchOfObjects(objectListing);
            S3Utils.fillMd5Map(name2md5, objectListing);
        }
        return name2md5;
    }

    private static void fillMd5Map(Map<String, String> name2md5, ObjectListing objectListing) {
        for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
            String objectKey = objectSummary.getKey();
            String objectMd5 = objectSummary.getETag();
            name2md5.put(objectKey, objectMd5);
        }
    }
}

