/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.services.s3.AmazonS3;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.configuration.ImageData;
import com.atlassian.aws.ec2.configuration.ImageFileDao;
import com.atlassian.bamboo.maven.plugins.aws.AbstractAwsMojo;
import com.atlassian.bamboo.maven.plugins.aws.HgUtils;
import com.atlassian.bamboo.maven.plugins.aws.S3Utils;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class S3UploadMojo
extends AbstractAwsMojo {
    public static final String JAR_CACHE = "jar-cache";
    protected static final String S3 = "s3";
    private String agentAssemblyBucketStem;
    private String agentAssemblyDirectoryParent;
    private String agentAssemblyDirectoryName;
    private File imageListFile;
    private MavenProject project;
    private String s3homeRegions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String assemblyKey = null;
        String sourceId = this.getSourceId();
        for (String s3region : StringUtils.split((String)this.s3homeRegions, (String)", ")) {
            assemblyKey = this.uploadData(AwsSupportConstants.translateToRegion((String)s3region), sourceId);
        }
        try {
            this.getLog().info((CharSequence)("Updating assembly data in " + this.imageListFile));
            ImageData imageData = ImageFileDao.readOrCreate((File)this.imageListFile);
            imageData.setAssemblyBucketStem(this.agentAssemblyBucketStem);
            imageData.setAssemblyKey(assemblyKey);
            ImageFileDao.write((ImageData)imageData, (File)this.imageListFile);
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Could not write image data file.", (Exception)exception);
        }
        this.getLog().info((CharSequence)("Assembly data written to " + this.imageListFile));
        this.project.getArtifact().setFile(this.imageListFile);
    }

    private String uploadData(AwsSupportConstants.Region destinationRegion, String sourceId) throws MojoExecutionException {
        String agentAssemblyBucketForRegion = ImageData.getNameForRegion((String)this.agentAssemblyBucketStem, (AwsSupportConstants.Region)destinationRegion);
        this.getLog().info((CharSequence)("Ensuring that bucket " + agentAssemblyBucketForRegion + " exists in region " + destinationRegion + "..."));
        AmazonS3 s3client = (AmazonS3)this.awsS3Client.get();
        AwsSupportConstants.Region actualRegion = AwsSupportConstants.translateToRegion((String)s3client.getBucketLocation(agentAssemblyBucketForRegion));
        if (actualRegion != destinationRegion) {
            throw new MojoExecutionException("Bucket " + agentAssemblyBucketForRegion + " is defined in region " + actualRegion + ", it should be defined in " + destinationRegion);
        }
        File assemblyDirFile = new File(this.agentAssemblyDirectoryParent).getAbsoluteFile();
        String bambooVersion = this.project.getVersion();
        Map<String, String> cachedName2Md5Hash = S3Utils.getObjectNamesAndHashes((AmazonS3)this.awsS3Client.get(), agentAssemblyBucketForRegion, JAR_CACHE);
        String assemblyKey = S3UploadMojo.getAssemblyS3DirLocation(bambooVersion, sourceId);
        Map<String, String> existingName2Md5Hash = S3Utils.getObjectNamesAndHashes((AmazonS3)this.awsS3Client.get(), agentAssemblyBucketForRegion, assemblyKey);
        String assemblyRemoteLocation = agentAssemblyBucketForRegion + "/" + assemblyKey;
        this.project.getProperties().put("assemblyRemoteLocation", assemblyRemoteLocation);
        this.getLog().info((CharSequence)("Uploading from: " + assemblyDirFile + " to s3://" + assemblyRemoteLocation + "..."));
        Iterator files = FileUtils.iterateFiles((File)assemblyDirFile, null, (boolean)true);
        HashSet localFiles = Sets.newHashSet();
        while (files.hasNext()) {
            File assemblyFile = (File)files.next();
            String calculatedAssemblyFileMd5Hex = this.calculateMd5Hex(assemblyFile);
            String fileKey = S3UploadMojo.getFileKey(bambooVersion, sourceId, assemblyDirFile, assemblyFile);
            localFiles.add(fileKey);
            boolean alreadyInDestination = calculatedAssemblyFileMd5Hex.equals(existingName2Md5Hash.get(fileKey));
            String cachedFileKey = "jar-cache/" + assemblyFile.getName();
            boolean alreadyInCache = calculatedAssemblyFileMd5Hex.equals(cachedName2Md5Hash.get(cachedFileKey));
            String destinationLocation = "s3://" + agentAssemblyBucketForRegion + "/" + fileKey;
            if (alreadyInDestination) {
                this.getLog().info((CharSequence)("Already available : " + destinationLocation + "..."));
                continue;
            }
            if (alreadyInCache) {
                this.getLog().info((CharSequence)("Copying from cache: " + destinationLocation + "..."));
                s3client.copyObject(agentAssemblyBucketForRegion, cachedFileKey, agentAssemblyBucketForRegion, fileKey);
                continue;
            }
            this.getLog().info((CharSequence)("Uploading         : " + destinationLocation + "..."));
            s3client.putObject(agentAssemblyBucketForRegion, fileKey, assemblyFile);
            this.getLog().debug((CharSequence)("Copying to cache: " + cachedFileKey + "..."));
            s3client.copyObject(agentAssemblyBucketForRegion, fileKey, agentAssemblyBucketForRegion, cachedFileKey);
        }
        this.removeSpuriousFiles(agentAssemblyBucketForRegion, localFiles, existingName2Md5Hash.keySet());
        return assemblyKey;
    }

    private void removeSpuriousFiles(String bucket, Set<String> srcFileKeys, Set<String> dstFileKeys) {
        this.getLog().debug((CharSequence)("Local files: " + srcFileKeys.size() + ", remote files: " + dstFileKeys.size()));
        Sets.SetView spuriousFileKeys = Sets.difference(dstFileKeys, srcFileKeys);
        for (String spuriousFileKey : spuriousFileKeys) {
            this.getLog().info((CharSequence)("Removing " + spuriousFileKey + " from destination..."));
            ((AmazonS3)this.awsS3Client.get()).deleteObject(bucket, spuriousFileKey);
        }
    }

    private String getSourceId() {
        String id;
        try {
            id = HgUtils.getId(this.getLog());
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)("Unable to retrieve VCS id, generating a random one, reason: " + e));
            id = "NOVCS-" + RandomStringUtils.randomAlphanumeric((int)12) + "+";
        }
        return id.endsWith("+") ? id + System.getProperty("user.name") : id;
    }

    private static String getFileKey(String bambooVersionDir, String sourceId, File assemblyBaseDir, File assemblyFile) {
        String fileNameUnderAssemblyDir = StringUtils.removeStart((String)assemblyFile.getAbsolutePath(), (String)(assemblyBaseDir.getAbsolutePath() + File.separatorChar));
        return S3UploadMojo.getAssemblyS3DirLocation(bambooVersionDir, sourceId) + "/" + fileNameUnderAssemblyDir;
    }

    private static String getAssemblyS3DirLocation(String bambooVersionDir, String sourceId) {
        return bambooVersionDir + "/" + sourceId;
    }

    private String calculateMd5Hex(File assemblyFile) throws MojoExecutionException {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(assemblyFile);
            string = DigestUtils.md5Hex((InputStream)fis);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Unable to calculate MD5 of " + assemblyFile, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return string;
    }
}

