/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class HgUtils {
    private static final String HG = "hg";

    private HgUtils() {
    }

    public static String getId(Log log) {
        LinkedList output = Lists.newLinkedList();
        HgUtils.runHg(log, output, "id", "-i");
        if (output.isEmpty() || StringUtils.isBlank((String)((String)output.get(0)))) {
            throw new UnsupportedOperationException("Empty id received");
        }
        return (String)output.get(0);
    }

    private static int runHg(Log log, Collection<String> output, String ... arguments) {
        String command = null;
        try {
            List<String> argList = Arrays.asList(arguments);
            LinkedList<String> commandList = new LinkedList<String>();
            commandList.add(HG);
            commandList.addAll(argList);
            ProcessBuilder processBuilder = new ProcessBuilder(commandList);
            processBuilder.redirectErrorStream(true);
            command = StringUtils.join(processBuilder.command(), (char)' ');
            log.info((CharSequence)("Running command: '" + command + "'."));
            Process process = processBuilder.start();
            List processOutput = IOUtils.readLines((InputStream)process.getInputStream());
            output.clear();
            output.addAll(processOutput);
            return process.waitFor();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("An error has occured when running hg command: " + command, e);
        }
    }
}

