/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.configuration.ImageData;
import com.atlassian.aws.ec2.configuration.ImageFileDao;
import com.atlassian.bamboo.maven.plugins.aws.AbstractAwsMojo;
import com.atlassian.bamboo.maven.plugins.aws.S3Utils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jetbrains.annotations.NotNull;

public class FillShadowBuckets
extends AbstractAwsMojo {
    private String homeRegionStr;
    private String shadowRegionsStr;
    private String agentAssemblyBucketStem;
    private String dirKey;
    private File awsDataFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.homeRegionStr = this.homeRegionStr.replaceFirst(",.*", "");
        AwsSupportConstants.Region homeRegion = AwsSupportConstants.translateToRegion((String)this.homeRegionStr);
        ArrayList shadowRegions = Lists.newArrayList();
        for (String shadowRegion : StringUtils.split((String)this.shadowRegionsStr, (String)", ")) {
            shadowRegions.add(AwsSupportConstants.translateToRegion((String)shadowRegion));
        }
        String homeBucketName = ImageData.getNameForRegion((String)this.agentAssemblyBucketStem, (AwsSupportConstants.Region)homeRegion);
        this.getLog().info((CharSequence)("Copying data from bucket " + homeBucketName + " in region " + homeRegion + " to regions " + shadowRegions));
        if (StringUtils.isBlank((String)this.dirKey)) {
            try {
                this.dirKey = ImageFileDao.read((File)this.awsDataFile).getAssemblyKey();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Bucket key unknown: you have to specify it via the property s3.bucketKey or put it into a file: " + this.awsDataFile, (Exception)e);
            }
            if (StringUtils.isBlank((String)this.dirKey)) {
                throw new MojoExecutionException("Unable to find assembly key in file: " + this.awsDataFile);
            }
        }
        for (AwsSupportConstants.Region shadowRegion : shadowRegions) {
            this.copyData(homeBucketName, this.dirKey, shadowRegion);
        }
    }

    private void copyData(@NotNull String srcBucket, @NotNull String dirKey, @NotNull AwsSupportConstants.Region dstRegion) {
        String dstBucket = ImageData.getNameForRegion((String)this.agentAssemblyBucketStem, (AwsSupportConstants.Region)dstRegion);
        this.getLog().info((CharSequence)("=== Copying data: s3://" + srcBucket + "/" + dirKey + " -> " + dstBucket + " ==="));
        this.getLog().info((CharSequence)"Fetching the list of objects from source...");
        Map<String, String> objectsInSrc = S3Utils.getObjectNamesAndHashes((AmazonS3)this.awsS3Client.get(), srcBucket, dirKey);
        this.getLog().info((CharSequence)"Fetching the list of objects in destination...");
        Map<String, String> objectsInDst = S3Utils.getObjectNamesAndHashes((AmazonS3)this.awsS3Client.get(), dstBucket, dirKey);
        this.getLog().info((CharSequence)"Fetching region-local cached objects...");
        Map<String, String> objectsInDstCache = S3Utils.getObjectNamesAndHashes((AmazonS3)this.awsS3Client.get(), dstBucket, "jar-cache");
        this.getLog().info((CharSequence)"Transferring...");
        for (Map.Entry<String, String> srcObject : objectsInSrc.entrySet()) {
            String objectKey = srcObject.getKey();
            String objectHash = srcObject.getValue();
            if (objectHash.equals(objectsInDst.get(objectKey))) {
                this.getLog().info((CharSequence)("Available      : " + objectKey));
                continue;
            }
            String objectName = objectKey.replaceFirst(".*/", "");
            String objectKeyInCache = "jar-cache/" + objectName;
            if (objectHash.equals(objectsInDstCache.get(objectKeyInCache))) {
                this.getLog().info((CharSequence)("From cache     : " + objectKey));
                this.copyObject(dstBucket, objectKeyInCache, dstBucket, objectKey);
                continue;
            }
            this.getLog().info((CharSequence)("Region transfer: " + objectKey));
            this.copyObject(srcBucket, objectKey, dstBucket, objectKey);
            this.copyObject(srcBucket, objectKey, dstBucket, objectKeyInCache);
        }
    }

    private void copyObject(String srcBucket, String srcKey, String dstBucket, String dstKey) {
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucket, srcKey, dstBucket, dstKey).withStorageClass(StorageClass.ReducedRedundancy);
        try {
            ((AmazonS3)this.awsS3Client.get()).copyObject(copyObjectRequest);
        }
        catch (AmazonClientException e) {
            this.getLog().error((CharSequence)("An exception has occurred during transfer: [" + srcBucket + "] :: [" + srcKey + "] -> [" + dstBucket + "] :: [" + dstKey + "]"));
            throw e;
        }
    }
}

