/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.maven.plugins.aws.AbstractImageRebuildMojo;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.PropertyUtils;
import org.jetbrains.annotations.NotNull;

public class Ec2RunMojo
extends AbstractImageRebuildMojo {
    private static final String IMAGE_ARCHITECTURE_32 = "i386";
    private static final String BAMBOO_BASE_IMAGE_PREFIX = "bamboo-base";
    private String ec2ImageID;
    private File imageListFile;
    private File ec2InstanceIDFile;
    private String ec2KeyName;
    private String instanceType32;
    private String instanceType64;
    private final Map<String, Image> imageDescriptions = new MapMaker().makeComputingMap((Function)new Function<String, Image>(){

        public Image apply(String imageId) {
            DescribeImagesRequest describeImagesRequest = new DescribeImagesRequest().withImageIds(new String[]{imageId});
            DescribeImagesResult describeImagesResult = Ec2RunMojo.this.getAwsEc2Client().describeImages(describeImagesRequest);
            return (Image)describeImagesResult.getImages().get(0);
        }
    });

    @NotNull
    private String getAwsInstanceTypeForImage(String imageId) {
        String imageArchitecture = this.imageDescriptions.get(imageId).getArchitecture();
        boolean is32bitImage = imageArchitecture.equals(IMAGE_ARCHITECTURE_32);
        return is32bitImage ? this.instanceType32 : this.instanceType64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeMojo() throws MojoExecutionException {
        try {
            this.ec2InstanceIDFile.getParentFile().mkdirs();
            FileWriter fileWriter = new FileWriter(this.ec2InstanceIDFile);
            try {
                for (String imageId : this.getImagesToRun()) {
                    String instanceId = this.runImage(imageId);
                    this.tagInstance(instanceId);
                    fileWriter.write(instanceId + "\n");
                }
            }
            finally {
                fileWriter.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing instance file", (Exception)e);
        }
    }

    private Iterable<String> getImagesToRun() throws MojoExecutionException {
        if (StringUtils.isNotBlank((String)this.ec2ImageID)) {
            return Lists.newArrayList((Object[])new String[]{this.ec2ImageID});
        }
        ArrayList imagesToRun = Lists.newArrayList();
        Properties images = PropertyUtils.loadProperties((File)this.imageListFile);
        Set<Object> imageTypes = images.keySet();
        for (Object imageTypeObject : imageTypes) {
            String imageType = (String)imageTypeObject;
            if (!imageType.startsWith(BAMBOO_BASE_IMAGE_PREFIX)) continue;
            imagesToRun.add((String)images.get(imageType));
        }
        return imagesToRun;
    }

    private String runImage(String imageId) throws MojoExecutionException {
        RunInstancesResult runInstancesResult;
        Log log = this.getLog();
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest().withImageId(imageId).withMinCount(Integer.valueOf(1)).withMaxCount(Integer.valueOf(1)).withInstanceInitiatedShutdownBehavior(AwsSupportConstants.InstanceInitiatedShutdownBehaviour.TERMINATE.toString()).withClientToken(RandomStringUtils.randomAlphanumeric((int)64));
        Image image = this.imageDescriptions.get(imageId);
        String instanceType = this.getAwsInstanceTypeForImage(imageId);
        log.info((CharSequence)("Starting instance using a base image " + imageId + ", architecture: " + image.getArchitecture() + ", root device type: " + image.getRootDeviceType() + ", instance type: " + instanceType));
        runInstancesRequest.setInstanceType(instanceType);
        if (this.ec2KeyName != null) {
            runInstancesRequest.setKeyName(this.ec2KeyName);
            log.info((CharSequence)("Using " + this.ec2KeyName + " key pair."));
        }
        try {
            runInstancesResult = this.getAwsEc2Client().runInstances(runInstancesRequest);
        }
        catch (AmazonServiceException exception) {
            throw new MojoExecutionException("Could not run instances.", (Exception)((Object)exception));
        }
        Instance instance = (Instance)Iterables.getOnlyElement((Iterable)runInstancesResult.getReservation().getInstances());
        log.info((CharSequence)("Instance " + instance.getInstanceId() + " starting."));
        return instance.getInstanceId();
    }

    private void tagInstance(String instanceId) {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "???";
        }
        this.addTag(instanceId, "Name", "mvn::" + hostname + "::" + System.getProperty("user.name"));
    }
}

