/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.CreateImageRequest;
import com.amazonaws.services.ec2.model.CreateImageResult;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.RegisterImageRequest;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.configuration.ImageData;
import com.atlassian.aws.ec2.configuration.ImageFileDao;
import com.atlassian.bamboo.maven.plugins.aws.AbstractImageRebuildMojo;
import com.atlassian.bamboo.maven.plugins.aws.Ec2InstanceIdFile;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.scm.manager.ScmManager;

public class Ec2CreateImageMojo
extends AbstractImageRebuildMojo {
    private static final int IMAGE_STATUS_POLL_INTERVAL_SECONDS = 15;
    private static final long IMAGE_CREATION_TIMEOUT_MINUTES = 30L;
    private static final String IMAGE_STATE_PENDING = "pending";
    private ScmManager scmManager;
    private String manifest;
    private File amiIDFile;
    private String ec2ImageTag;
    private File ec2InstanceIDFile;
    private String windowsDefaultAmiId;

    @Override
    public void executeMojo() throws MojoExecutionException {
        Log log = this.getLog();
        DescribeInstancesResult describeInstancesResult = this.describeInstances(new Ec2InstanceIdFile(this.ec2InstanceIDFile).read());
        HashMap imagesFromInstances = Maps.newHashMap();
        for (Reservation reservation : describeInstancesResult.getReservations()) {
            for (Instance instance : reservation.getInstances()) {
                log.info((CharSequence)("Instance: " + instance.getInstanceId() + ", root device type: " + instance.getRootDeviceType()));
                String createdImageId = this.createImage(log, instance);
                imagesFromInstances.put(instance, createdImageId);
            }
        }
        this.tagAndStore(imagesFromInstances);
    }

    private String createImage(Log log, Instance instance) throws MojoExecutionException {
        return instance.getRootDeviceType().equalsIgnoreCase("ebs") ? this.createEbsImage(log, instance) : this.registerImage(log, instance);
    }

    private void tagAndStore(Map<Instance, String> imagesFromInstances) throws MojoExecutionException {
        Log log = this.getLog();
        ImageData imageData = null;
        if (this.amiIDFile != null) {
            try {
                imageData = ImageFileDao.readOrCreate((File)this.amiIDFile);
            }
            catch (IOException exception) {
                throw new MojoExecutionException("Could not write AMI ID file.", (Exception)exception);
            }
        }
        for (Map.Entry<Instance, String> imageFromInstance : imagesFromInstances.entrySet()) {
            String createdImageId = imageFromInstance.getValue();
            Instance sourceInstance = imageFromInstance.getKey();
            if (StringUtils.isNotEmpty((String)this.ec2ImageTag)) {
                this.addTag(createdImageId, "Name", this.ec2ImageTag);
            }
            if (imageData == null) continue;
            AwsSupportConstants.RootDeviceType rootDeviceType = AwsSupportConstants.RootDeviceType.fromAwsName((String)sourceInstance.getRootDeviceType());
            AwsSupportConstants.Architecture architecture = AwsSupportConstants.Architecture.fromAwsName((String)sourceInstance.getArchitecture());
            AwsSupportConstants.Platform platform = AwsSupportConstants.Platform.linux;
            if (sourceInstance.getPlatform() != null) {
                platform = AwsSupportConstants.Platform.fromAwsName((String)sourceInstance.getPlatform());
            }
            imageData.add(new ImageData.ImageDefinition(this.getRegion(), rootDeviceType, architecture, platform, createdImageId));
        }
        if (!StringUtils.isBlank((String)this.windowsDefaultAmiId)) {
            imageData.add(new ImageData.ImageDefinition(AwsSupportConstants.Region.US_EAST_1, AwsSupportConstants.RootDeviceType.EBS, AwsSupportConstants.Architecture.x86_64, AwsSupportConstants.Platform.windows, this.windowsDefaultAmiId));
        }
        if (imageData != null) {
            try {
                ImageFileDao.write((ImageData)imageData, (File)this.amiIDFile);
                this.project.getArtifact().setFile(this.amiIDFile);
            }
            catch (IOException exception) {
                throw new MojoExecutionException("Could not write image ids to file.", (Exception)exception);
            }
            log.info((CharSequence)("Image ids written to " + this.amiIDFile));
        }
    }

    private String registerImage(Log log, Instance instance) throws MojoExecutionException {
        String imageId;
        String interpolatedManifest = this.getManifest(this.manifest, instance);
        log.info((CharSequence)("Registering manifest " + interpolatedManifest));
        try {
            RegisterImageRequest registerImageRequest = new RegisterImageRequest(interpolatedManifest);
            imageId = this.getAwsEc2Client().registerImage(registerImageRequest).getImageId();
        }
        catch (AmazonServiceException exception) {
            throw new MojoExecutionException("Could not register image.", (Exception)((Object)exception));
        }
        log.info((CharSequence)("Image registered: " + imageId));
        return imageId;
    }

    private String getManifest(String manifest, Instance instance) {
        return manifest.replace("ARCH", instance.getArchitecture()).replace("-SNAPSHOT", "");
    }

    private String createEbsImage(Log log, Instance instance) throws MojoExecutionException {
        String imageState;
        CreateImageResult createImageResult;
        String imageSource = this.describeImage(instance.getImageId()).getName().replace("bamboo-base", this.project.getVersion()) + System.currentTimeMillis() / 1000L;
        String instanceId = instance.getInstanceId();
        log.info((CharSequence)("Creating image [" + imageSource + "] from a running instance: " + instanceId));
        CreateImageRequest createImageRequest = new CreateImageRequest().withInstanceId(instanceId).withName(imageSource);
        try {
            createImageResult = this.getAwsEc2Client().createImage(createImageRequest);
        }
        catch (AmazonClientException exception) {
            throw new MojoExecutionException("Could not register image.", (Exception)((Object)exception));
        }
        String imageId = createImageResult.getImageId();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        do {
            if (stopWatch.getTime() > TimeUnit.MINUTES.toMillis(30L)) {
                throw new MojoExecutionException("Could not create image in alotted time.");
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
            }
            catch (InterruptedException e) {
                log.warn((CharSequence)"", (Throwable)e);
            }
            imageState = this.describeImage(imageId).getState();
            log.info((CharSequence)("Image status: " + imageState + ", elapsed time " + stopWatch.toString()));
        } while (imageState.equalsIgnoreCase(IMAGE_STATE_PENDING));
        log.info((CharSequence)("Image created: " + imageId));
        this.terminateInstance(instanceId);
        return imageId;
    }

    private TerminateInstancesResult terminateInstance(String instanceId) {
        this.getLog().info((CharSequence)("Terminating instance " + instanceId));
        TerminateInstancesRequest req = new TerminateInstancesRequest().withInstanceIds(new String[]{instanceId});
        return this.getAwsEc2Client().terminateInstances(req);
    }

    private Image describeImage(String imageId) {
        DescribeImagesRequest describeImagesRequest = new DescribeImagesRequest().withImageIds(new String[]{imageId});
        return (Image)this.getAwsEc2Client().describeImages(describeImagesRequest).getImages().get(0);
    }
}

