/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws.files;

import com.atlassian.bamboo.maven.plugins.aws.files.Consumer;
import com.atlassian.bamboo.maven.plugins.aws.files.Generator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.maven.project.MavenProject;

public class FileTools {
    private static final String ENCODING = "UTF-8";

    private FileTools() {
    }

    public static void createParentFiles(File file) {
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(File file, Consumer consumer) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, ENCODING);
            try {
                consumer.consume(reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, Generator generator) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, ENCODING);
            try {
                generator.generate(writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        finally {
            outputStream.close();
        }
    }

    public static File defaultPrivateKeyFile(File ec2PrivateKeyFile, String ec2KeyName, MavenProject project) {
        if (ec2PrivateKeyFile == null) {
            return new File(new File(project.getBuild().getDirectory(), "ec2"), "pk" + (ec2KeyName == null ? "" : "-" + ec2KeyName) + ".pem");
        }
        return ec2PrivateKeyFile;
    }
}

