/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.atlassian.aws.ec2.configuration.ImageData;
import com.atlassian.aws.ec2.configuration.ImageFileDao;
import com.atlassian.bamboo.maven.plugins.aws.AbstractAwsMojo;
import com.atlassian.bamboo.maven.plugins.aws.HgUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3UploadMojo
extends AbstractAwsMojo {
    private static final String JAR_CACHE = "jar-cache";
    protected static final String S3 = "s3";
    private String agentAssemblyBucket;
    private String agentAssemblyDirectoryParent;
    private String agentAssemblyDirectoryName;
    private File amiIDFile;
    private MavenProject project;
    private String amiIds;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Ensuring that bucket " + this.agentAssemblyBucket + " exists..."));
        AmazonS3 s3client = (AmazonS3)this.awsS3Client.get();
        s3client.createBucket(this.agentAssemblyBucket);
        File assemblyDirFile = new File(this.agentAssemblyDirectoryParent).getAbsoluteFile();
        String bambooVersion = this.project.getVersion();
        String sourceId = this.getSourceId();
        Map<String, String> cachedName2Md5Hash = this.getObjectSummaries(this.agentAssemblyBucket, JAR_CACHE);
        String assemblyParentKey = this.getAssemblyS3DirLocation(bambooVersion, sourceId);
        Map<String, String> existingName2Md5Hash = this.getObjectSummaries(this.agentAssemblyBucket, assemblyParentKey);
        String assemblyKey = assemblyParentKey + "/" + this.agentAssemblyDirectoryName;
        String assemblyRemoteLocation = this.agentAssemblyBucket + "/" + assemblyKey;
        this.project.getProperties().put("assemblyRemoteLocation", assemblyRemoteLocation);
        this.getLog().info((CharSequence)("Uploading from: " + assemblyDirFile + " to s3://" + assemblyRemoteLocation + "..."));
        Iterator files = FileUtils.iterateFiles((File)assemblyDirFile, null, (boolean)true);
        HashSet localFiles = Sets.newHashSet();
        while (files.hasNext()) {
            File assemblyFile = (File)files.next();
            String calculatedAssemblyFileMd5Hex = this.calculateMd5Hex(assemblyFile);
            String fileKey = this.getFileKey(bambooVersion, sourceId, assemblyDirFile, assemblyFile);
            localFiles.add(fileKey);
            boolean alreadyInDestination = calculatedAssemblyFileMd5Hex.equals(existingName2Md5Hash.get(fileKey));
            String cachedFileKey = "jar-cache/" + assemblyFile.getName();
            boolean alreadyInCache = calculatedAssemblyFileMd5Hex.equals(cachedName2Md5Hash.get(cachedFileKey));
            if (alreadyInDestination) {
                this.getLog().info((CharSequence)("Already copied: " + fileKey + " / " + calculatedAssemblyFileMd5Hex + "..."));
                continue;
            }
            if (alreadyInCache) {
                this.getLog().info((CharSequence)("Copying from cache: " + cachedFileKey + " / " + calculatedAssemblyFileMd5Hex + "..."));
                s3client.copyObject(this.agentAssemblyBucket, cachedFileKey, this.agentAssemblyBucket, fileKey);
                continue;
            }
            this.getLog().info((CharSequence)("Uploading " + fileKey + " / " + calculatedAssemblyFileMd5Hex + "..."));
            s3client.putObject(this.agentAssemblyBucket, fileKey, assemblyFile);
            this.getLog().info((CharSequence)("Copying to cache: " + cachedFileKey + "..."));
            s3client.copyObject(this.agentAssemblyBucket, fileKey, this.agentAssemblyBucket, cachedFileKey);
        }
        this.removeSpuriousFiles(localFiles, existingName2Md5Hash.keySet());
        try {
            ImageData imageData = this.readOrCreateImageData();
            imageData.setAssemblyBucket(this.agentAssemblyBucket);
            imageData.setAssemblyKey(assemblyKey);
            for (String id : StringUtils.split((String)this.amiIds, (char)',')) {
                imageData.add(new ImageData.ImageDefinition(id));
            }
            ImageFileDao.write((ImageData)imageData, (File)this.amiIDFile);
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Could not write image data file.", (Exception)exception);
        }
        this.getLog().info((CharSequence)("Assembly data written to " + this.amiIDFile));
        this.project.getArtifact().setFile(this.amiIDFile);
    }

    private void removeSpuriousFiles(Set<String> localFiles, Set<String> remoteFileKeys) {
        this.getLog().info((CharSequence)("Local files: " + localFiles.size() + ", remote files: " + remoteFileKeys.size()));
        Sets.SetView spuriousFileKeys = Sets.difference(remoteFileKeys, localFiles);
        for (String spuriousFileKey : spuriousFileKeys) {
            this.getLog().info((CharSequence)("Removing " + spuriousFileKey + " from destination..."));
            ((AmazonS3)this.awsS3Client.get()).deleteObject(this.agentAssemblyBucket, spuriousFileKey);
        }
    }

    private ImageData readOrCreateImageData() {
        try {
            return ImageFileDao.read((File)this.amiIDFile);
        }
        catch (IOException e) {
            return new ImageData();
        }
    }

    private String getSourceId() {
        String id;
        try {
            id = HgUtils.getId(this.getLog());
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)("Unable to retrieve VCS id, generating a random one, reason: " + e));
            id = "NOVCS-" + RandomStringUtils.randomAlphanumeric((int)12) + "+";
        }
        return id.endsWith("+") ? id + System.getProperty("user.name") : id;
    }

    private String getFileKey(String bambooVersionDir, String sourceId, File assemblyBaseDir, File assemblyFile) {
        String fileNameUnderAssemblyDir = StringUtils.removeStart((String)assemblyFile.getAbsolutePath(), (String)(assemblyBaseDir.getAbsolutePath() + File.separatorChar));
        return this.getAssemblyS3DirLocation(bambooVersionDir, sourceId) + "/" + fileNameUnderAssemblyDir;
    }

    private String getAssemblyS3DirLocation(String bambooVersionDir, String sourceId) {
        return bambooVersionDir + "/" + sourceId;
    }

    private String calculateMd5Hex(File assemblyFile) throws MojoFailureException {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(assemblyFile);
            string = DigestUtils.md5Hex((InputStream)fis);
        }
        catch (IOException e) {
            try {
                throw new MojoFailureException("Unable to calculate MD5 of " + assemblyFile, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return string;
    }

    private Map<String, String> getObjectSummaries(String bucket, String prefix) {
        ObjectListing objectListing = ((AmazonS3)this.awsS3Client.get()).listObjects(bucket, prefix);
        HashMap name2md5 = Maps.newHashMap();
        this.fillMd5Map(name2md5, objectListing);
        while (objectListing.isTruncated()) {
            objectListing = ((AmazonS3)this.awsS3Client.get()).listNextBatchOfObjects(objectListing);
            this.fillMd5Map(name2md5, objectListing);
        }
        return name2md5;
    }

    private void fillMd5Map(Map<String, String> name2md5, ObjectListing objectListing) {
        for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
            String objectKey = objectSummary.getKey();
            String objectMd5 = objectSummary.getETag();
            name2md5.put(objectKey, objectMd5);
        }
    }
}

