/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import com.atlassian.bamboo.maven.plugins.aws.AbstractImageRebuildMojo;
import com.atlassian.bamboo.maven.plugins.aws.Ec2InstanceIdFile;
import com.atlassian.bamboo.maven.plugins.aws.InputStreamConsumer;
import com.atlassian.bamboo.maven.plugins.aws.files.FileTools;
import com.google.common.collect.Lists;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public class Ec2SshMojo
extends AbstractImageRebuildMojo {
    private File ec2InstanceIDFile;
    private String ec2KeyName;
    private File ec2PrivateKeyFile;
    private String user;
    private String[] files;
    private String destination;
    private String command;
    private MavenProject project;

    private static void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void executeMojo() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        JSch jSch = new JSch();
        this.ec2PrivateKeyFile = FileTools.defaultPrivateKeyFile(this.ec2PrivateKeyFile, this.ec2KeyName, this.project);
        log.info((CharSequence)("Using private key file " + this.ec2PrivateKeyFile));
        try {
            jSch.addIdentity(this.ec2PrivateKeyFile.toString());
        }
        catch (JSchException exception) {
            throw new MojoExecutionException("Private key file " + this.ec2PrivateKeyFile + " is invalid.", (Exception)((Object)exception));
        }
        ArrayList instanceIds = new Ec2InstanceIdFile(this.ec2InstanceIDFile).read();
        log.info((CharSequence)("Waiting for the following instances to come up: " + instanceIds));
        while (!instanceIds.isEmpty()) {
            List reservations;
            ArrayList pendingInstanceIds = Lists.newArrayList();
            try {
                reservations = this.describeInstances(instanceIds).getReservations();
            }
            catch (AmazonServiceException exception) {
                throw new MojoExecutionException("Could not get instance descriptions.", (Exception)((Object)exception));
            }
            for (Reservation reservation : reservations) {
                List instances = reservation.getInstances();
                for (Instance instance : instances) {
                    String host = instance.getPublicDnsName();
                    if (StringUtils.isBlank((String)host)) {
                        pendingInstanceIds.add(instance.getInstanceId());
                        continue;
                    }
                    this.runSession(log, jSch, host);
                }
            }
            instanceIds = pendingInstanceIds;
            if (instanceIds.isEmpty()) continue;
            Ec2SshMojo.sleep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSession(Log log, JSch jSch, String host) throws MojoExecutionException, MojoFailureException {
        log.info((CharSequence)("Connecting to " + host));
        Properties properties = new Properties();
        properties.setProperty("StrictHostKeyChecking", "no");
        try {
            Session session = this.openSession(jSch, host, properties);
            try {
                this.putFiles(session, log);
                this.executeCommand(session, log);
            }
            finally {
                session.disconnect();
            }
        }
        catch (MojoFailureException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Connection to " + host + " failed.", exception);
        }
    }

    private Session openSession(JSch jSch, String host, Properties properties) throws JSchException {
        int retry = 0;
        while (true) {
            try {
                Session session = jSch.getSession(this.user, host);
                session.setConfig(properties);
                session.connect(10000);
                return session;
            }
            catch (JSchException exception) {
                this.getLog().debug((Throwable)exception);
                if (retry >= 20) {
                    throw exception;
                }
                Ec2SshMojo.sleep();
                ++retry;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFiles(Session session, Log log) throws JSchException, SftpException {
        if (this.files != null && this.files.length > 0) {
            File basedir = this.project.getBasedir();
            ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
            channel.connect();
            try {
                for (String file : this.files) {
                    String absoluteFile = new File(file).isAbsolute() ? file : new File(basedir, file).getAbsolutePath();
                    String validDestination = this.destination == null ? "." : this.destination;
                    channel.put(absoluteFile, validDestination, (SftpProgressMonitor)new ProgressMonitor(log));
                }
            }
            finally {
                channel.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(Session session, Log log) throws Exception {
        if (this.command != null) {
            InputStreamConsumer errorStreamConsumer;
            InputStreamConsumer inputStreamConsumer;
            log.info((CharSequence)("Executing " + this.command));
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand(this.command);
            channel.connect();
            try {
                inputStreamConsumer = new InputStreamConsumer(channel.getInputStream(), System.out);
                errorStreamConsumer = new InputStreamConsumer(channel.getErrStream(), System.err);
                Thread inputThread = new Thread(inputStreamConsumer);
                Thread errorThread = new Thread(errorStreamConsumer);
                inputThread.start();
                errorThread.start();
                inputThread.join();
                errorThread.join();
            }
            finally {
                channel.disconnect();
            }
            inputStreamConsumer.check();
            errorStreamConsumer.check();
            int exitStatus = channel.getExitStatus();
            if (exitStatus != 0) {
                throw new MojoFailureException("Exit status was non-zero: " + exitStatus);
            }
        }
    }

    private static class ProgressMonitor
    implements SftpProgressMonitor {
        private final Log log;
        private long max;
        private long lastProgressIn10s = -1L;
        private long transferredSoFar = 0L;

        public ProgressMonitor(Log log) {
            this.log = log;
        }

        public void init(int op, String src, String dest, long max) {
            this.max = max;
            String opString = op == 0 ? "Sending" : "Fetching";
            this.log.info((CharSequence)(opString + " " + src + " to " + dest + ", transfer size: " + FileUtils.byteCountToDisplaySize((int)((int)max))));
        }

        public boolean count(long count) {
            this.transferredSoFar += count;
            long progressPercentage = this.transferredSoFar * 100L / this.max;
            long progressIn10s = progressPercentage / 10L;
            if (progressIn10s != this.lastProgressIn10s) {
                this.lastProgressIn10s = progressIn10s;
                if (this.transferredSoFar != this.max) {
                    this.log.info((CharSequence)(progressPercentage + "% transferred, " + FileUtils.byteCountToDisplaySize((int)((int)(this.max - this.transferredSoFar))) + " remaining..."));
                }
            }
            return true;
        }

        public void end() {
            this.log.info((CharSequence)"Transfer completed.");
        }
    }
}

