/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.Image;
import com.atlassian.bamboo.maven.plugins.aws.AbstractImageRebuildMojo;
import com.atlassian.bamboo.maven.plugins.aws.Ec2InstanceIdFile;
import com.atlassian.util.concurrent.LazyReference;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.ReservationDescription;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.scm.manager.ScmManager;

public class Ec2RunMojo
extends AbstractImageRebuildMojo {
    private static final String IMAGE_ARCHITECTURE_32 = "i386";
    private ScmManager manager;
    private String ec2ImageID;
    private File ec2InstanceIDFile;
    private String ec2KeyName;
    private String instanceType32;
    private String instanceType64;
    private final LazyReference<String> instanceType = new LazyReference<String>(){

        protected String create() throws Exception {
            DescribeImagesRequest describeImagesRequest = new DescribeImagesRequest().withImageIds(new String[]{Ec2RunMojo.this.ec2ImageID});
            DescribeImagesResult describeImagesResult = Ec2RunMojo.this.getAwsEc2Client().describeImages(describeImagesRequest);
            String imageArchitecture = ((Image)describeImagesResult.getImages().get(0)).getArchitecture();
            Ec2RunMojo.this.getLog().info((CharSequence)("Architecture of base image " + Ec2RunMojo.this.ec2ImageID + " is " + imageArchitecture));
            boolean is32bitImage = imageArchitecture.equals(Ec2RunMojo.IMAGE_ARCHITECTURE_32);
            return is32bitImage ? Ec2RunMojo.this.instanceType32 : Ec2RunMojo.this.instanceType64;
        }
    };

    public void executeMojo() throws MojoExecutionException {
        ReservationDescription reservationDescription;
        Log log = this.getLog();
        LaunchConfiguration launchConfiguration = new LaunchConfiguration(this.ec2ImageID);
        if (this.instanceType.get() != null) {
            log.info((CharSequence)("Using custom instance type: " + (String)this.instanceType.get()));
            launchConfiguration.setInstanceType(InstanceType.getTypeFromString((String)((String)this.instanceType.get())));
        }
        if (this.ec2KeyName != null) {
            launchConfiguration.setKeyName(this.ec2KeyName);
            log.info((CharSequence)("Using " + this.ec2KeyName + " key pair."));
        }
        Jec2 jec2 = this.getJec2();
        try {
            reservationDescription = jec2.runInstances(launchConfiguration);
        }
        catch (EC2Exception exception) {
            throw new MojoExecutionException("Could not run instances.", (Exception)((Object)exception));
        }
        List instances = reservationDescription.getInstances();
        for (ReservationDescription.Instance instance : instances) {
            log.info((CharSequence)("Instance " + instance.getInstanceId() + " starting."));
            this.tagInstance(instance);
        }
        new Ec2InstanceIdFile(this.ec2InstanceIDFile).write(instances, log);
        int instanceCount = instances.size();
        if (instanceCount != 1) {
            throw new MojoExecutionException("Expected 1 instance, but " + instanceCount + " were created.");
        }
    }

    private void tagInstance(ReservationDescription.Instance instance) {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "???";
        }
        this.addTag(instance.getInstanceId(), "Name", "mvn::" + hostname + "::" + System.getProperty("user.name"));
    }
}

