/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.atlassian.bamboo.maven.plugins.aws.AbstractAwsMojo;
import com.atlassian.bamboo.maven.plugins.aws.Ec2InstanceIdFile;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.Jec2;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class Ec2KillMojo
extends AbstractAwsMojo {
    private File ec2InstanceIDFile;

    public void execute() throws MojoExecutionException {
        List<String> instanceIds = new Ec2InstanceIdFile(this.ec2InstanceIDFile).read();
        Jec2 jec2 = this.getJec2();
        try {
            jec2.terminateInstances(instanceIds);
        }
        catch (EC2Exception exception) {
            throw new MojoExecutionException("Could not terminate instances.", (Exception)((Object)exception));
        }
        for (String instanceId : instanceIds) {
            this.getLog().info((CharSequence)("Instance " + instanceId + " terminating."));
        }
    }
}

