/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.atlassian.bamboo.maven.plugins.aws.files.Consumer;
import com.atlassian.bamboo.maven.plugins.aws.files.FileTools;
import com.atlassian.bamboo.maven.plugins.aws.files.Generator;
import com.xerox.amazonws.ec2.ReservationDescription;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Ec2InstanceIdFile {
    private static final String SEPARATOR = "\n";
    private final File file;

    Ec2InstanceIdFile(File file) {
        this.file = file;
    }

    List<String> read() throws MojoExecutionException {
        if (this.file == null || !this.file.exists()) {
            return Collections.emptyList();
        }
        final ArrayList<String> instanceIds = new ArrayList<String>();
        Consumer consumer = new Consumer(){

            public void consume(Reader reader) throws IOException {
                int character;
                StringBuilder instanceId = new StringBuilder();
                int separatorIndex = 0;
                while ((character = reader.read()) >= 0) {
                    if (character == Ec2InstanceIdFile.SEPARATOR.charAt(separatorIndex)) {
                        if (++separatorIndex < Ec2InstanceIdFile.SEPARATOR.length()) continue;
                        instanceIds.add(instanceId.toString());
                        instanceId.setLength(0);
                        separatorIndex = 0;
                        continue;
                    }
                    instanceId.append((char)character);
                }
                instanceId.append(Ec2InstanceIdFile.SEPARATOR, 0, separatorIndex);
                if (instanceId.length() > 0) {
                    instanceIds.add(instanceId.toString());
                }
            }
        };
        try {
            FileTools.read(this.file, consumer);
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Could not read instance ID file.", (Exception)exception);
        }
        return instanceIds;
    }

    void write(final List<ReservationDescription.Instance> instances, Log log) throws MojoExecutionException {
        if (this.file != null) {
            FileTools.createParentFiles(this.file);
            try {
                FileTools.write(this.file, new Generator(){

                    public void generate(Writer writer) throws IOException {
                        for (ReservationDescription.Instance instance : instances) {
                            String instanceId = instance.getInstanceId();
                            if (instanceId.contains(Ec2InstanceIdFile.SEPARATOR)) {
                                throw new IOException("Instance ID contains unexpected characters: \"" + instanceId + "\".");
                            }
                            writer.write(instanceId);
                            writer.write(Ec2InstanceIdFile.SEPARATOR);
                        }
                    }
                });
            }
            catch (IOException exception) {
                throw new MojoExecutionException("Could not write instance ID file.", (Exception)exception);
            }
            log.info((CharSequence)("Instance IDs written to " + this.file));
        }
    }
}

