/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.model.CreateImageRequest;
import com.amazonaws.services.ec2.model.CreateImageResult;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import com.atlassian.aws.ec2.configuration.ImageData;
import com.atlassian.aws.ec2.configuration.ImageFileDao;
import com.atlassian.bamboo.maven.plugins.aws.AbstractImageRebuildMojo;
import com.atlassian.bamboo.maven.plugins.aws.Ec2InstanceIdFile;
import com.google.common.collect.Lists;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.Jec2;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ec2CreateImageMojo
extends AbstractImageRebuildMojo {
    private static final int IMAGE_STATUS_POLL_INTERVAL_SECONDS = 15;
    private static final long IMAGE_CREATION_TIMEOUT_MINUTES = 30L;
    private static final String IMAGE_STATE_PENDING = "pending";
    private ScmManager scmManager;
    private MavenProject project;
    private String manifest;
    private File amiIDFile;
    private String ec2ImageTag;
    private File ec2InstanceIDFile;

    @Override
    public void executeMojo() throws MojoExecutionException {
        Log log = this.getLog();
        DescribeInstancesResult describeInstancesResult = this.describeInstances(new Ec2InstanceIdFile(this.ec2InstanceIDFile).read());
        LinkedList amiIds = Lists.newLinkedList();
        for (Reservation reservation : describeInstancesResult.getReservations()) {
            for (Instance instance : reservation.getInstances()) {
                log.info((CharSequence)("Instance: " + instance.getInstanceId() + ", root device type: " + instance.getRootDeviceType()));
                String amiId = instance.getRootDeviceType().equalsIgnoreCase("ebs") ? this.createImage(instance) : this.registerImage(log);
                amiIds.add(amiId);
            }
        }
        this.tagAndStore(amiIds);
    }

    private void tagAndStore(List<String> amiIds) throws MojoExecutionException {
        Log log = this.getLog();
        if (StringUtils.isNotEmpty((String)this.ec2ImageTag)) {
            for (String amiId : amiIds) {
                this.addTag(amiId, "Name", this.ec2ImageTag);
                try {
                    ScmRepository scmRepository = this.scmManager.makeScmRepository(this.project.getScm().getConnection());
                    InfoScmResult result = this.scmManager.getProviderByRepository(scmRepository).info(scmRepository.getProviderRepository(), new ScmFileSet(this.project.getBasedir()), null);
                    String revision = ((InfoItem)result.getInfoItems().get(0)).getRevision();
                    this.addTag(amiId, "Revision", revision);
                }
                catch (Exception e) {
                    log.warn((CharSequence)"Unable to retrieve the workspace revision, will not tag the image with it", (Throwable)e);
                }
            }
        }
        if (this.amiIDFile != null) {
            try {
                ImageData imageData = ImageFileDao.read((File)this.amiIDFile);
                for (String amiId : amiIds) {
                    imageData.add(new ImageData.ImageDefinition(amiId));
                }
                ImageFileDao.write((ImageData)imageData, (File)this.amiIDFile);
            }
            catch (IOException exception) {
                throw new MojoExecutionException("Could not write AMI ID file.", (Exception)exception);
            }
            log.info((CharSequence)("AMI ID written to " + this.amiIDFile));
            this.project.getArtifact().setFile(this.amiIDFile);
        }
    }

    private String registerImage(Log log) throws MojoExecutionException {
        String imageId;
        Jec2 jec2 = this.getJec2();
        log.info((CharSequence)("Registering manifest " + this.manifest));
        try {
            imageId = jec2.registerImage(this.manifest);
        }
        catch (EC2Exception exception) {
            throw new MojoExecutionException("Could not register image.", (Exception)((Object)exception));
        }
        log.info((CharSequence)("Image registered: " + imageId));
        return imageId;
    }

    private String createImage(Instance instance) throws MojoExecutionException {
        String imageState;
        CreateImageResult createImageResult;
        Log log = this.getLog();
        String imageSource = this.describeImage(instance.getImageId()).getName().replace("bamboo-base", this.project.getVersion()) + System.currentTimeMillis() / 1000L;
        String instanceId = instance.getInstanceId();
        log.info((CharSequence)("Creating image [" + imageSource + "] from a running instance: " + instanceId));
        CreateImageRequest createImageRequest = new CreateImageRequest().withInstanceId(instanceId).withName(imageSource);
        try {
            createImageResult = this.getAwsEc2Client().createImage(createImageRequest);
        }
        catch (AmazonClientException exception) {
            throw new MojoExecutionException("Could not register image.", (Exception)((Object)exception));
        }
        String imageId = createImageResult.getImageId();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        do {
            if (stopWatch.getTime() > TimeUnit.MINUTES.toMillis(30L)) {
                throw new MojoExecutionException("Could not create image in alotted time.");
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
            }
            catch (InterruptedException e) {
                log.warn((CharSequence)"", (Throwable)e);
            }
            imageState = this.describeImage(imageId).getState();
            log.info((CharSequence)("Image status: " + imageState + ", elapsed time " + stopWatch.toString()));
        } while (imageState.equalsIgnoreCase(IMAGE_STATE_PENDING));
        log.info((CharSequence)("Image created: " + imageId));
        this.terminateInstance(instanceId);
        return imageId;
    }

    private TerminateInstancesResult terminateInstance(String instanceId) {
        this.getLog().info((CharSequence)("Terminating instance " + instanceId));
        TerminateInstancesRequest req = new TerminateInstancesRequest().withInstanceIds(new String[]{instanceId});
        return this.getAwsEc2Client().terminateInstances(req);
    }

    private Image describeImage(String imageId) {
        DescribeImagesRequest describeImagesRequest = new DescribeImagesRequest().withImageIds(new String[]{imageId});
        return (Image)this.getAwsEc2Client().describeImages(describeImagesRequest).getImages().get(0);
    }
}

