/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.atlassian.bamboo.maven.plugins.aws.AbstractAwsMojo;
import com.atlassian.bamboo.maven.plugins.aws.files.FileTools;
import com.atlassian.bamboo.maven.plugins.aws.files.Generator;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class Ec2AddKey
extends AbstractAwsMojo {
    private String ec2KeyName;
    private File ec2PrivateKeyFile;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        this.ec2PrivateKeyFile = FileTools.defaultPrivateKeyFile(this.ec2PrivateKeyFile, this.ec2KeyName, this.project);
        if (this.ec2PrivateKeyFile.exists()) {
            log.warn((CharSequence)("Private key file " + this.ec2PrivateKeyFile + " already exists.  Skipping key pair generation."));
        } else {
            KeyPairInfo keyPairInfo;
            Jec2 jec2 = this.getJec2();
            try {
                keyPairInfo = jec2.createKeyPair(this.ec2KeyName);
            }
            catch (EC2Exception exception) {
                throw new MojoExecutionException("Could not create key pair.", (Exception)((Object)exception));
            }
            log.info((CharSequence)("Key pair " + this.ec2KeyName + " created."));
            FileTools.createParentFiles(this.ec2PrivateKeyFile);
            Generator generator = new Generator(){

                public void generate(Writer writer) throws IOException {
                    writer.write(keyPairInfo.getKeyMaterial());
                }
            };
            try {
                FileTools.write(this.ec2PrivateKeyFile, generator);
            }
            catch (IOException exception) {
                throw new MojoExecutionException("Could not write private key file.", (Exception)exception);
            }
            log.info((CharSequence)("Private key written to " + this.ec2PrivateKeyFile));
        }
    }
}

