/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.maven.plugins.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.atlassian.util.concurrent.LazyReference;
import com.xerox.amazonws.ec2.Jec2;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAwsMojo
extends AbstractMojo {
    private static final int MAX_AWS_RETRIES = 4;
    private static final int DELAY_BETWEEN_AWS_RETRIES_SECONDS = 30;
    private String awsAccessKeyID;
    private String awsSecretAccessKey;
    private final LazyReference<Jec2> jec2 = new LazyReference<Jec2>(){

        protected Jec2 create() throws Exception {
            return new Jec2(AbstractAwsMojo.this.awsAccessKeyID, AbstractAwsMojo.this.awsSecretAccessKey);
        }
    };
    private final LazyReference<AmazonEC2> awsEc2Client = new LazyReference<AmazonEC2>(){

        protected AmazonEC2 create() throws Exception {
            return new AmazonEC2Client((AWSCredentials)new BasicAWSCredentials(AbstractAwsMojo.this.awsAccessKeyID, AbstractAwsMojo.this.awsSecretAccessKey));
        }
    };
    protected final LazyReference<AmazonS3> awsS3Client = new LazyReference<AmazonS3>(){

        protected AmazonS3Client create() throws Exception {
            return new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(AbstractAwsMojo.this.awsAccessKeyID, AbstractAwsMojo.this.awsSecretAccessKey));
        }
    };

    AbstractAwsMojo() {
    }

    Jec2 getJec2() {
        return (Jec2)this.jec2.get();
    }

    AmazonEC2 getAwsEc2Client() {
        return (AmazonEC2)this.awsEc2Client.get();
    }

    void addTag(String resourceId, String key, String value) {
        this.getLog().info((CharSequence)("Tagging resource " + resourceId + ": [" + key + "=" + value + "]"));
        boolean isTagCreated = false;
        int tagAttempt = 1;
        do {
            try {
                CreateTagsRequest createTagsRequest = new CreateTagsRequest().withResources(new String[]{resourceId}).withTags(new Tag[]{new Tag(key, value)});
                this.getAwsEc2Client().createTags(createTagsRequest);
                isTagCreated = true;
            }
            catch (AmazonServiceException e) {
                if (tagAttempt == 4) {
                    throw e;
                }
                this.getLog().warn((CharSequence)("Unable to tag resource " + resourceId + ", attempt " + tagAttempt + ", retrying in " + 30 + " seconds, "), (Throwable)e);
                ++tagAttempt;
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
                }
                catch (InterruptedException e2) {
                    throw e;
                }
            }
        } while (!isTagCreated);
    }

    @NotNull
    protected DescribeInstancesResult describeInstances(@NotNull List<String> instanceIds) throws MojoExecutionException {
        DescribeInstancesResult describeInstancesResult;
        boolean areAllInstancesDescribed;
        DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest().withInstanceIds(instanceIds);
        int triesLeft = 4;
        do {
            int instancesDescribed = 0;
            describeInstancesResult = this.getAwsEc2Client().describeInstances(describeInstancesRequest);
            for (Reservation reservation : describeInstancesResult.getReservations()) {
                instancesDescribed += reservation.getInstances().size();
            }
            boolean bl = areAllInstancesDescribed = instancesDescribed == instanceIds.size();
            if (areAllInstancesDescribed) continue;
            --triesLeft;
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        } while (!areAllInstancesDescribed && triesLeft > 0);
        if (!areAllInstancesDescribed) {
            throw new MojoExecutionException("Unable to find started instances on AWS side");
        }
        return describeInstancesResult;
    }
}

