package com.atlassian.maven.plugins.sourcerelease.util;

import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

import java.io.*;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipHelper {
    Log log;

    public ZipHelper(Log log) {
        this.log = log;
    }

    public void unzipArchive(File archive, File outputDir, boolean makeFilesExecutable)
    {
        try
        {
            ZipFile zipfile = new ZipFile(archive);
            for (Enumeration e = zipfile.entries(); e.hasMoreElements(); )
            {
                ZipEntry entry = (ZipEntry) e.nextElement();
                unzipEntry(zipfile, entry, outputDir, makeFilesExecutable);
            }
        }
        catch (Exception e)
        {
            log.error("Error while extracting file " + archive, e);
        }
    }

    private void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir, boolean makeFilesExecutable) throws IOException
    {

        if (entry.isDirectory())
        {
            createDir(new File(outputDir, entry.getName()));
            return;
        }

        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists())
        {
            createDir(outputFile.getParentFile());
        }

        log.debug("Extracting: " + entry);
        BufferedInputStream inputStream = new BufferedInputStream(zipfile.getInputStream(entry));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));

        try
        {
            IOUtils.copy(inputStream, outputStream);
            if (makeFilesExecutable)
            {
                outputFile.setExecutable(true, false);
            }
        }
        finally
        {
            outputStream.close();
            inputStream.close();
        }
    }

    private void createDir(File dir)
    {
        log.debug("Creating dir "+dir.getName());
        if(!dir.mkdirs()) throw new RuntimeException("Can not create dir " + dir);
    }
}