package com.atlassian.maven.plugins.sourcerelease.util;


import org.apache.commons.lang.StringUtils;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class WindowsScriptHelper extends DefaultScriptHelper implements ScriptHelper
{
    private Map<String, String> mavenMap = new HashMap<String, String>();

    public WindowsScriptHelper(File directory, String filename, boolean withTests)
    {
        super(directory, filename, withTests);
        this.newLine = "\n";
        this.extraCli = " %* ";
        this.preliminaryLines.add("@echo off");
        this.mavenMap.put(MavenVersion.MAVEN2.getCmd(), "mvn2.bat");
        this.mavenMap.put(MavenVersion.MAVEN3.getCmd(), "mvn3.bat");
    }

    public void addSettingsLine(String settingsFilename)
    {
        this.preliminaryLines.add("set SETTINGSFILE=" + settingsFilename);
        this.addToMavenCommands("-s %SETTINGSFILE%");
    }

    public void addLocalRepoLine(String localRepoFilename)
    {
        this.preliminaryLines.add("set LOCALREPO=" + localRepoFilename);
        this.addToMavenCommands("-Dmaven.repo.local=%cd%\\%LOCALREPO%");
    }

    public void addCurrentDirToPath()
    {
        this.preliminaryLines.add("set PATH=%cd%;%PATH%");
    }

    public void useErrorMode()
    {
        this.betweenEachCommand = "if %errorlevel% neq 0 exit /b %errorlevel%";
    }

    public void addOtherPreliminaryLine(String line)
    {
        this.preliminaryLines.add(line);
    }

    public void addCommand(String command, boolean isMaven, boolean takesExtraCli)
    {
        this.addCommand(command, "", isMaven, takesExtraCli);
    }

    public void addCommand(String command, String arguments, boolean isMaven, boolean takesExtraCli)
    {
        String cmd = command;
        if (isMaven)
        {
            cmd = mavenMap.get(command);
        }

        if(!StringUtils.isBlank(arguments))
        {
            cmd = cmd + " " + arguments;
        }

        if (isMaven)
        {
            cmd = cmd + appendToMavenCommands;
        }

        if (takesExtraCli)
        {
            cmd = cmd + this.extraCli;
        }
        cmd = "call " + cmd;
        this.commands.add(cmd);
    }
}
