package com.atlassian.maven.plugins.sourcerelease.util;

/**
 * Class representing a specific maven command to run
 */
public class FinalMavenBuildCommand {
    
    private MavenVersion mavenVersion;

    /**
     * @parameter
     */
    private String cmdArgs;

    /**
     * @parameter
     */
    private boolean useMaven3;
    
    public FinalMavenBuildCommand()
    {
        this.cmdArgs = "";
        this.mavenVersion = MavenVersion.MAVEN2;
    }
    
    public FinalMavenBuildCommand(String cmdArgs, boolean useMaven3)
    {
        this.cmdArgs = cmdArgs;
        this.useMaven3 = useMaven3;
        if (this.useMaven3)
        {
            this.mavenVersion = MavenVersion.MAVEN3;
        }
    }
    
    public MavenVersion getMavenVersion()
    {
        if (this.useMaven3)
        {
            this.mavenVersion = MavenVersion.MAVEN3;
        }
        return this.mavenVersion;
    }
    
    public String getCmdArgs()
    {
        return this.cmdArgs;
    }
}
