package com.atlassian.maven.plugins.sourcerelease.configurations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Maps multiple modules to a single repository
 *
 * @since v4.1
 */
public class RepositoryMapping
{
    /**
     * @parameter
     */
    private String baseRepository;

    /**
     * @parameter
     */
    private Map moduleMapping;

    /**
     * @parameter
     */
    private boolean resolveRoot;

    /**
     * @parameter
     */
    private String[] repositoryModules;

    public RepositoryMapping()
    {
    }

    public RepositoryMapping(final String baseRepository, final Map moduleMapping, final boolean resolveRoot, final String[] repositoryModules)
    {
        this.baseRepository = baseRepository;
        this.moduleMapping = moduleMapping;
        this.resolveRoot = resolveRoot;
        this.repositoryModules = repositoryModules;
    }

    public Map<String, String> getModuleMapping()
    {
        return moduleMapping == null ? Collections.<String, String>emptyMap() : (Map<String, String>) moduleMapping;
    }

    public String getBaseRepository()
    {
        return baseRepository;
    }

    public boolean isResolveRoot()
    {
        return resolveRoot;
    }

    public List<String> getRepositoryModules()
    {
        return repositoryModules == null ? Collections.<String>emptyList() : Arrays.asList(repositoryModules);
    }
}
