package com.atlassian.maven.plugins.sourcerelease.util.filters;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OrArtifactFilter implements ArtifactFilter
{
    private final List filters = new ArrayList();

    public boolean include( Artifact artifact )
    {
        boolean include = false;
        for ( Iterator i = filters.iterator(); i.hasNext() && !include; )
        {
            ArtifactFilter filter = (ArtifactFilter) i.next();
            if ( filter.include( artifact ) )
            {
                include = true;
            }
        }
        return include;
    }

    public void add( ArtifactFilter artifactFilter )
    {
        filters.add( artifactFilter );
    }
}
