package com.atlassian.maven.plugins.sourcerelease.util;


import java.io.File;
import java.io.IOException;

public interface ScriptHelper {

    /**
     * Writes the stored script info out to file
     * @throws IOException
     */
    public void writeScript() throws IOException;

    /**
     * Adds a "-s settingsFilename" to all maven commands
     * @param settingsFilename
     */
    public void addSettingsLine(String settingsFilename);

    /**
     * Adds "-Dmaven.repo.local=localRepoFilename" to all maven commands
     */
    public void addLocalRepoLine(String localRepoFilename);

    /**
     * Adds a command to put the current directory in the system path
     */
    public void addCurrentDirToPath();

    /**
     * Makes the script halt on the first error rather than plowing on
     */
    public void useErrorMode();

    /**
     * Allows adding of extra commands before the main project commands
     * @param line
     */
    public void addOtherPreliminaryLine(String line);

    /**
     * Adds a command without any arguments
     * @param command
     * @param isMaven
     * @param takesExtraCli
     */
    public void addCommand(String command, boolean isMaven, boolean takesExtraCli);

    /**
     * Adds a command with arguments
     * @param command
     * @param arguments
     * @param isMaven
     * @param takesExtraCli
     */
    public void addCommand(String command, String arguments, boolean isMaven, boolean takesExtraCli);

    /**
     * Copies a maven settings file for inclusion in the source distribution.
     * @param sourceFilename
     * @param destFilename
     * @throws IOException
     */
    public void includeSettingsFile(String sourceFilename, String destFilename) throws IOException;
}
