package com.atlassian.maven.plugins.sourcerelease.util;


import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.FileUtils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class DefaultScriptHelper implements ScriptHelper{
    protected String filename;
    protected File directory;
    protected FileWriter fileWriter;

    protected List<String> preliminaryLines = new ArrayList<String>();
    protected List<String> commands = new ArrayList<String>();
    protected String betweenEachCommand = "";
    protected String newLine = "";
    protected String appendToMavenCommands = "";
    protected String extraCli = "";

    public DefaultScriptHelper(File directory, String filename, boolean withTests)
    {
        this.filename = filename;
        this.directory = directory;
        if (!withTests)
        {
            this.appendToMavenCommands = " -Dmaven.test.skip";
        }
    }

    public void writeScript() throws IOException{
        File scriptFile = new File(directory, filename);
        this.fileWriter = new FileWriter(scriptFile);
        for (String preliminary : preliminaryLines)
        {
            fileWriter.write(preliminary + newLine);
        }
        
        for (String command : commands)
        {
            fileWriter.write(command + newLine);
            if(!StringUtils.isBlank(betweenEachCommand))
            {
                fileWriter.write(betweenEachCommand + newLine);
            }
        }

        scriptFile.setExecutable(true, false);
        fileWriter.flush();
        fileWriter.close();
    }
    
    protected void addToMavenCommands(String extraArgs)
    {
        this.appendToMavenCommands = this.appendToMavenCommands + " " + extraArgs;
    }

    public void includeSettingsFile(String sourceFilename, String destFilename) throws IOException {
        FileUtils.copyFile(new File(sourceFilename), new File(this.directory, destFilename));
    }
}
