package com.atlassian.maven.plugins.sourcerelease.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum SCMPathType
{
    TAG("/tags", false),
    TRUNK("/trunk", true),
    BRANCH("/branches", false),
    //GIT(".git", true),
    UNKNOWN("", true);

    private final String marker;
    private final boolean parentPathElementNeeded;


    SCMPathType(final String marker, final boolean parentPathElementNeeded)
    {
        this.marker = marker;
        this.parentPathElementNeeded = parentPathElementNeeded;
    }

    public String getMarker()
    {
        return marker;
    }

    public boolean isParentPathElementNeeded()
    {
        return parentPathElementNeeded;
    }

    public List<String> determinePathElements(final String connection)
    {

        final List<String> pathElements = new ArrayList<String>();

        final String pathToSubmodule = getPathToSubModule(connection);

        // Damn you JDK 1.5 and arrays...
        pathElements.addAll(Arrays.asList(pathToSubmodule.split("/")));

        // Remove the parent project from path, e.g. /tags/parent-project-to-remove/path/we/want
        if(!isParentPathElementNeeded())
        {
            pathElements.remove(0);
        }

        return pathElements;
    }

    public String getPathToSubModule(final String connection)
    {

        final String pathTypeMarker = getMarker();
        final int pathTypeMarkerLocation = connection.indexOf(pathTypeMarker);

        String pathToSubmodule = connection.substring(pathTypeMarkerLocation + pathTypeMarker.length());
        if(pathToSubmodule.startsWith("/"))
        {
            pathToSubmodule = pathToSubmodule.substring(1);
        }
        return pathToSubmodule;
    }

    public static SCMPathType determinePathType(final String path)
    {
        for(SCMPathType scmPathType : SCMPathType.values())
        {
            if(path.contains(scmPathType.getMarker()))
            {
                return scmPathType;
            }
        }
        return SCMPathType.UNKNOWN;
    }
}
