package com.atlassian.maven.plugins.sourcerelease.util;

import org.apache.commons.lang.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * Script helper for *nix shell script
 */
public class PosixScriptHelper extends DefaultScriptHelper implements ScriptHelper
{
    private Map<String, String> mavenMap = new HashMap<String, String>();
    
    public PosixScriptHelper(File directory, String filename, boolean withTests)
    {
        super(directory, filename, withTests);
        this.newLine = "\n";
        this.extraCli = " \"$@\"";
        this.preliminaryLines.add("#! /bin/sh");
        this.preliminaryLines.add("cd \"`dirname \"$0\"`\"");
        this.mavenMap.put(MavenVersion.MAVEN2.getCmd(), "mvn2.sh");
        this.mavenMap.put(MavenVersion.MAVEN3.getCmd(), "mvn3.sh");
    }

    public void addSettingsLine(String settingsFilename)
    {
        this.preliminaryLines.add("SETTINGSFILE=\"" + settingsFilename + "\"");
        this.addToMavenCommands("-s $SETTINGSFILE");
    }

    public void addLocalRepoLine(String localRepoFilename)
    {
        this.preliminaryLines.add("LOCALREPO=\"" + localRepoFilename + "\"");
        this.addToMavenCommands("-Dmaven.repo.local=\"`pwd`/$LOCALREPO\"");
    }

    public void addCurrentDirToPath()
    {
        this.preliminaryLines.add("export PATH=.:$PATH");
    }

    public void useErrorMode()
    {
        this.preliminaryLines.add("set -e");
    }

    public void addOtherPreliminaryLine(String line)
    {
        this.preliminaryLines.add(line);
    }

    public void addCommand(String command, boolean isMaven, boolean takesExtraCli)
    {
        this.addCommand(command, "", isMaven, takesExtraCli);
    }
    
    public void addCommand(String command, String arguments, boolean isMaven, boolean takesExtraCli)
    {
        String cmd = command;
        if (isMaven)
        {
            cmd = mavenMap.get(command);
        }
        
        if(!StringUtils.isBlank(arguments))
        {
            cmd = cmd + " " + arguments;
        }

        if (isMaven)
        {
            cmd = cmd + appendToMavenCommands;
        }

        if (takesExtraCli)
        {
            cmd = cmd + this.extraCli;
        }
        this.commands.add(cmd);
    }
}
