package com.atlassian.maven.plugins.sourcerelease.mojos.hg;

import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.hg.command.HgConsumer;

import java.util.Properties;

public class HgPathConsumer extends HgConsumer
{
    private static final int MAX_TOKENS = 2;
    Properties aliases = new Properties();
    public HgPathConsumer(ScmLogger logger) {
        super(logger);
    }

    @Override
    public void doConsume(ScmFileStatus status, String trimmedLine) {
        String[] split = trimmedLine.split("\\s*=\\s*", MAX_TOKENS);
        if (split.length==MAX_TOKENS)
        {
            aliases.put(split[0], split[1]);
        }
    }

    String getPathForAlias(String alias)
    {
        return aliases.getProperty(alias);
    }
}
