package com.atlassian.maven.plugins.sourcerelease.mojos.git;

/**
 * @Deprecated since 1.6, use {@code com.atlassian.maven.plugins.sourcerelease.mojos.git.RepositoryAndRef} instead.
 */
@Deprecated
public class RepositoryAndTag
{
    private final String repositoryUrl;
    private final String tag;
    
    public RepositoryAndTag(String repositoryUrl, String tag)
    {
        this.repositoryUrl = repositoryUrl;
        this.tag = tag;
    }

    String getRepositoryUrl()
    {
        return repositoryUrl;
    }
    
    String getTag()
    {
        return tag;
    }
    
    @Override
    public int hashCode()
    {
        final int prime = 31;
        return prime * (prime + repositoryUrl.hashCode()) + tag.hashCode();
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj instanceof RepositoryAndTag)
        {
            RepositoryAndTag other = (RepositoryAndTag) obj;
            
            return repositoryUrl.equals(other.repositoryUrl) && tag.equals(other.tag);
        }
        else
        {
            return false;
        }
    }

    /**
     * @return a unique filename for this combination of repository and tag
     */
    public String getExportFilename()
    {
        return filterUnsafe(repositoryUrl) + "-" + filterUnsafe(tag) + "-" + Integer.toHexString(hashCode());
    }
    
    static String filterUnsafe(String s)
    {
        return s.replaceAll("[^a-zA-Z0-9]", "_");
    }
    
    public String toString()
    {
        return repositoryUrl + " " + tag;
    }
}
