package com.atlassian.maven.plugins.sourcerelease.mojos.git;

public final class Ref
{
    enum Type
    {
        Tag("refs/tags"), Head("refs/heads");
        private final String prefix;

        Type(String prefix)
        {
            this.prefix = prefix;
        }

        String format(String name)
        {
            return prefix + "/" + name;
        }
    }

    public static String tag(String ref)
    {
        return Type.Tag.format(ref);
    }

    public static String head(String ref)
    {
        return Type.Head.format(ref);
    }
}
