package com.atlassian.maven.plugins.sourcerelease.configurations;

import com.atlassian.maven.plugins.sourcerelease.util.MavenVersion;
import org.apache.commons.lang.StringUtils;

/**
 *  Allows users to specify specific build configurations for each dependency
 */
public class BuildConfiguration
{
    /**
     * @parameter
     */
    private String groupId;
    
    /**
     * @parameter
     */
    private String artifactId;

    /**
     * @parameter
     */
    private String buildCmd;

    /**
     * @parameter
     */
    private String cmdArgs;

    /**
     * @parameter
     */
    private boolean maven;

    /**
     * @parameter
     */
    private boolean useMaven3;

    /**
     * @parameter
     */
    private boolean overrideAutoMavenVersion;

    /**
     * @parameter default-value="true"
     */
    private boolean takesCliArgs;

    public BuildConfiguration()
    {

    }
    
    public BuildConfiguration (final String groupId, final String artifactId, final String buildCmd, final String cmdArgs, final boolean maven, final boolean useMaven3,
                               final boolean overrideAutoMavenVersion, final boolean takesCliArgs)
    {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.buildCmd = buildCmd;
        this.cmdArgs = cmdArgs;
        this.maven = maven;
        this.useMaven3 = useMaven3;
        this.overrideAutoMavenVersion = overrideAutoMavenVersion;
        this.takesCliArgs = takesCliArgs;
    }
    
    public String getGroupId()
    {
        return this.groupId;
    }
    
    public String getArtifactId()
    {
        return this.artifactId;
    }
    
    public String getBuildCmd()
    {
        if (StringUtils.isBlank(this.buildCmd))
        {
            if(maven && useMaven3)
            {
                return MavenVersion.MAVEN3.getCmd();
            }
            else
            {
                return MavenVersion.MAVEN2.getCmd();
            }
        }
        return this.buildCmd;
    }

    public boolean overrideMavenVersion()
    {
        if(useMaven3)
        {
            //If they have specified a particular version, then we should honor that.
            return true;
        }
        return this.overrideAutoMavenVersion;
    }
    
    public String getCmdArgs()
    {
        if (StringUtils.isBlank(this.cmdArgs))
        {
            return "";
        }
        return this.cmdArgs;
    }

    public boolean isMaven()
    {
        return this.maven;
    }

    public boolean takesCliArgs()
    {
        return this.takesCliArgs;
    }
}
