package com.atlassian.maven.plugins.sourcerelease.mojos.git;

public class RepositoryAndPath
{
    private final String repositoryUrl;
    private final String path;
    
    public RepositoryAndPath(String repositoryUrl, String path)
    {
        this.repositoryUrl = repositoryUrl;
        this.path = path;
    }

    String getRepositoryUrl()
    {
        return repositoryUrl;
    }
    
    String getPath()
    {
        return path;
    }
    
    @Override
    public int hashCode()
    {
        final int prime = 31;
        return prime * (prime + repositoryUrl.hashCode()) + path.hashCode();
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj instanceof RepositoryAndPath)
        {
            RepositoryAndPath other = (RepositoryAndPath) obj;
            
            return repositoryUrl.equals(other.repositoryUrl) && path.equals(other.path);
        }
        else
        {
            return false;
        }
    }
    
    @Override
    public String toString()
    {
        return repositoryUrl + " " + path;
    }
}
