package com.atlassian.maven.plugins.sourcerelease.configurations;

/**
 * Allows mapping the scm tag prefix for a dependency.
 * If a released artifact uses a different tag value then expected this mapping
 * can be used to specify what is expected.
 *
 * eg.
 * An artifact is released with the tag 'project1' instead of 'project1-parent'
 * then the mapping allows overriding to specify that it should use project1 as
 * the tag prefix instead.
 *
 * @since 1.6.1
 */
public class ReleaseArtifactMapping
{
    /**
     * @parameter
     */
    private String groupId;

    /**
     * @parameter
     */
    private String artifactId;

    /**
     * @parameter
     */
    private String scmTagPrefix;

    public ReleaseArtifactMapping()
    {
    }

    public ReleaseArtifactMapping(String groupId, String artifactId, String scmTagPrefix)
    {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.scmTagPrefix = scmTagPrefix;
    }

    public String getArtifactId()
    {
        return artifactId;
    }

    public String getGroupId()
    {
        return groupId;
    }

    public String getScmTagPrefix()
    {
        return scmTagPrefix;
    }
}
