package com.atlassian.maven.plugins.sourcerelease.mojos.git;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * Pair that combines a repository Url and a Ref.
 */
final class RepositoryAndRef
{
    private final String repositoryUrl;
    private final Ref ref;

    public RepositoryAndRef(String repositoryUrl, Ref ref)
    {
        this.repositoryUrl = repositoryUrl;
        this.ref = ref;
    }

    String getRepositoryUrl()
    {
        return repositoryUrl;
    }
    
    String getRefAsString()
    {
        return ref.toString();
    }

    Ref getRef()
    {
        return ref;
    }

    @Override
    public int hashCode()
    {
        return new HashCodeBuilder().append(ref).append(repositoryUrl).hashCode();
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj instanceof RepositoryAndRef)
        {
            RepositoryAndRef other = (RepositoryAndRef) obj;
            return new EqualsBuilder().append(repositoryUrl, other.repositoryUrl).append(ref, other.ref).isEquals();
        }
        return false;
    }

    /**
     * @return a unique filename for this combination of repository and tag
     */
    public String getExportFilename()
    {
        return filterUnsafe(repositoryUrl) + "-" + filterUnsafe(ref.toString()) + "-" + Integer.toHexString(hashCode());
    }
    
    static String filterUnsafe(String s)
    {
        return s.replaceAll("[^a-zA-Z0-9]", "_");
    }
    
    public String toString()
    {
        return repositoryUrl + " " + ref;
    }
}
