package com.atlassian.maven.plugins.sourcerelease.mojos.git;

public final class Ref
{

    enum Type
    {
        Tag("refs/tags"), Head("refs/heads");
        private final String prefix;

        Type(String prefix)
        {
            this.prefix = prefix;
        }

        String format(String name)
        {
            return prefix + "/" + name;
        }
    }

    public static Ref tag(String ref)
    {
        return new Ref(ref, Type.Tag);
    }

    public static Ref head(String ref)
    {
        return new Ref(ref, Type.Head);
    }

    private final String ref;

    private Ref(String name, Type type)
    {
        this.ref = type.format(name);
    }

    @Override public String toString()
    {
        return ref;
    }
}
