/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sourcerelease.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SCMPathType {
    TAG("/tags", false),
    TRUNK("/trunk", true),
    BRANCH("/branches", false),
    UNKNOWN("", true);

    private final String marker;
    private boolean parentPathElementNeeded;

    private SCMPathType(String marker, boolean parentPathElementNeeded) {
        this.marker = marker;
        this.parentPathElementNeeded = parentPathElementNeeded;
    }

    public String getMarker() {
        return this.marker;
    }

    public boolean isParentPathElementNeeded() {
        return this.parentPathElementNeeded;
    }

    public static List<String> determinePathElements(String connection, SCMPathType scmPathType) {
        ArrayList<String> pathElements = new ArrayList<String>();
        String pathToSubmodule = SCMPathType.getPathToSubModule(connection, scmPathType);
        pathElements.addAll(Arrays.asList(pathToSubmodule.split("/")));
        if (!scmPathType.isParentPathElementNeeded()) {
            pathElements.remove(0);
        }
        return pathElements;
    }

    public static String getPathToSubModule(String connection, SCMPathType scmPathType) {
        String pathTypeMarker = scmPathType.getMarker();
        int pathTypeMarkerLocation = connection.indexOf(pathTypeMarker);
        String pathToSubmodule = connection.substring(pathTypeMarkerLocation + pathTypeMarker.length());
        if (pathToSubmodule.startsWith("/")) {
            pathToSubmodule = pathToSubmodule.substring(1);
        }
        return pathToSubmodule;
    }

    public static SCMPathType determinePathType(String path) {
        for (SCMPathType scmPathType : SCMPathType.values()) {
            if (!path.contains(scmPathType.getMarker())) continue;
            return scmPathType;
        }
        return UNKNOWN;
    }
}

