/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sourcerelease.util;

import java.util.concurrent.Callable;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryingTaskExecutor<T> {
    private final Log log;
    public static final long DEFAULT_MAX_RETRY_DELAY = 20000L;
    public static final int DEFAULT_MAX_RETRIES = 5;
    public static final int DEFAULT_INITIAL_RETRY_DELAY = 1000;
    public static final int DEFAULT_BACK_OFF_MULTIPLIER = 2;
    private final long initialRetryDelay;
    private final long maxRetryDelay;
    private final int maxRetries;
    private final boolean useExponentialBackOff;
    private final long backOffMultiplier;
    private final boolean rethrowLastException;
    protected volatile T objectToReturn;
    private int failures;

    public RetryingTaskExecutor(long initialRetryDelay, long maxRetryDelay, int maxRetries, long backOffMultiplier, boolean useExponentialBackOff, boolean rethrowLastException, Log log) {
        this.initialRetryDelay = initialRetryDelay;
        this.maxRetryDelay = maxRetryDelay;
        this.maxRetries = maxRetries;
        this.useExponentialBackOff = useExponentialBackOff;
        this.backOffMultiplier = backOffMultiplier;
        this.rethrowLastException = rethrowLastException;
        this.log = log;
    }

    public RetryingTaskExecutor(Log log, int maxRetries) {
        this(1000L, 20000L, maxRetries, 2L, true, true, log);
    }

    public void runTask(Callable<T> task) throws Exception {
        this.runTask(task.getClass().getName(), task);
    }

    public void runTask(String taskName, Callable<T> task) throws Exception {
        boolean run = true;
        long retryDelay = this.initialRetryDelay;
        while (run) {
            run = this.rerun(task, taskName, retryDelay);
            if (this.useExponentialBackOff) {
                if ((retryDelay *= this.backOffMultiplier) <= this.maxRetryDelay) continue;
                retryDelay = this.maxRetryDelay;
                continue;
            }
            retryDelay = this.initialRetryDelay;
        }
    }

    private boolean rerun(Callable<T> task, String taskName, long retryDelay) throws Exception {
        try {
            this.objectToReturn = task.call();
            if (this.failures > 0) {
                this.log.info((CharSequence)("Task '" + taskName + "' finished successfully during retry number " + this.failures));
            }
            return false;
        }
        catch (Exception e) {
            ++this.failures;
            this.log.info((CharSequence)("Task '" + taskName + "' was unsuccessful. Run " + this.failures + " / " + this.maxRetries + ". Exception thrown when running task '" + taskName + "', with message: " + e.getMessage()));
            this.log.debug((CharSequence)"Full stack trace: ", (Throwable)e);
            if (this.failures >= this.maxRetries) {
                this.log.error((CharSequence)("Failed to run task '" + taskName + "' after " + this.failures + " attempts. Task was not executed."));
                if (this.rethrowLastException) {
                    this.log.error((CharSequence)"Exception being rethrown");
                    throw e;
                }
                this.log.error((CharSequence)"Final exception was ", (Throwable)e);
                return false;
            }
            this.log.info((CharSequence)("Waiting " + retryDelay + "ms before retrying..."));
            try {
                Thread.sleep(retryDelay);
                return true;
            }
            catch (InterruptedException inter) {
                this.log.warn((CharSequence)"Retry was interrupted! Task was not run.");
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    public T getObjectToReturn() {
        return this.objectToReturn;
    }
}

