/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sourcerelease.mojos;

import com.atlassian.maven.plugins.scm.ScmInfo;
import com.atlassian.maven.plugins.sourcerelease.mojos.AbstractSourceDistributionMojo;
import com.atlassian.maven.plugins.sourcerelease.util.RetryingTaskExecutor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceMojo
extends AbstractSourceDistributionMojo {
    private ScmManager manager;
    private int delay;
    private int retries;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping source distribution execution");
            return;
        }
        File checkoutDirectory = this.createCheckoutDirectory();
        Set<MavenProject> resolvedProjects = this.getResolvedProjects();
        List<String> modules = this.checkoutProjects(resolvedProjects, checkoutDirectory);
        MavenProject rootProject = (MavenProject)this.reactorProjects.get(0);
        this.getLog().info((CharSequence)("Checking out root project " + rootProject.getGroupId() + ":" + rootProject.getArtifactId()));
        try {
            this.doCheckout(rootProject, checkoutDirectory);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Subversion tag does not yet exist for project " + this.project.getGroupId() + ":" + this.project.getArtifactId()));
            this.getLog().debug((Throwable)e);
        }
        if (this.generatePom && !modules.isEmpty()) {
            this.writeSourceDistributionPom(modules, checkoutDirectory);
        }
    }

    private List<String> checkoutProjects(Set<MavenProject> projects, File checkoutDirectory) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Will checkout the following artifacts:");
        for (MavenProject currentProject : projects) {
            this.getLog().info((CharSequence)(currentProject.getGroupId() + ":" + currentProject.getArtifactId()));
        }
        this.getLog().info((CharSequence)("A delay of " + this.delay + " ms has been specified between checkouts."));
        ArrayList<String> modules = new ArrayList<String>();
        for (MavenProject currentProject : projects) {
            String projectArtifactId = currentProject.getArtifactId();
            if (modules.contains(projectArtifactId)) {
                throw new MojoExecutionException("Cannot have two modules checked out with the same directory name " + projectArtifactId);
            }
            modules.add(currentProject.getArtifactId());
            this.doCheckout(currentProject, checkoutDirectory);
        }
        return modules;
    }

    private void writeSourceDistributionPom(List<String> modules, File checkoutDirectory) throws MojoExecutionException {
        Exception ex = null;
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setName(this.productName + " Source Release");
        model.setPackaging("pom");
        model.setDescription("Source for " + this.productName);
        model.setModules(modules);
        try {
            FileWriter writer = new FileWriter(new File(checkoutDirectory, "pom.xml"));
            new MavenXpp3Writer().write((Writer)writer, model);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write source release pom", ex);
        }
    }

    private void doCheckout(final MavenProject project, final File checkoutDirectory) throws MojoExecutionException {
        final Scm scm = project.getScm();
        if (scm != null && scm.getConnection() != null) {
            try {
                RetryingTaskExecutor<Void> executor = new RetryingTaskExecutor<Void>(this.getLog(), this.retries);
                executor.runTask(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ScmRepository scmRepository = SourceMojo.this.getScmRepository(scm.getConnection());
                        SourceMojo.this.getLog().info((CharSequence)("Checking out " + project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion()));
                        ExportScmResult result = SourceMojo.this.getScmManager().export(scmRepository, new ScmFileSet(checkoutDirectory), project.getArtifactId());
                        if (SourceMojo.this.delay > 0) {
                            try {
                                Thread.sleep(SourceMojo.this.delay);
                            }
                            catch (InterruptedException e) {
                                throw new MojoExecutionException("Failed to delay checkout, root cause attached", (Exception)e);
                            }
                        }
                        SourceMojo.this.checkResult((ScmResult)result);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        } else {
            this.getLog().warn((CharSequence)("Skipping " + project.getArtifactId() + " as it did not have a valid <scm> tag"));
        }
    }

    private void checkResult(ScmResult result) throws MojoExecutionException {
        if (!result.isSuccess()) {
            this.getLog().error((CharSequence)"Provider message:");
            this.getLog().error((CharSequence)(result.getProviderMessage() == null ? "" : result.getProviderMessage()));
            this.getLog().error((CharSequence)"Command output:");
            this.getLog().error((CharSequence)(result.getCommandOutput() == null ? "" : result.getCommandOutput()));
            throw new MojoExecutionException("Command failed. " + StringUtils.defaultString((String)result.getProviderMessage()));
        }
    }

    private File createCheckoutDirectory() throws MojoExecutionException {
        String dirName = this.checkoutDirectoryName;
        File checkoutDirectory = new File(this.outputDirectory, dirName);
        if (!checkoutDirectory.exists() && !checkoutDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create directory " + checkoutDirectory.getAbsolutePath());
        }
        return checkoutDirectory;
    }

    private ScmManager getScmManager() {
        return this.manager;
    }

    private ScmRepository getScmRepository(String connectionUrl) throws ScmException {
        ScmRepository repository;
        try {
            repository = this.getScmManager().makeScmRepository(connectionUrl);
            if (repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
                ScmProviderRepositoryWithHost repo = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
                ScmInfo info = this.loadInfosFromSettings(repo);
                if (!StringUtils.isEmpty((String)info.getUsername())) {
                    repo.setUser(info.getUsername());
                }
                if (!StringUtils.isEmpty((String)info.getPassword())) {
                    repo.setPassword(info.getPassword());
                }
                if (!StringUtils.isEmpty((String)info.getPrivateKey())) {
                    repo.setPrivateKey(info.getPrivateKey());
                }
                if (!StringUtils.isEmpty((String)info.getPassphrase())) {
                    repo.setPassphrase(info.getPassphrase());
                }
            }
        }
        catch (ScmRepositoryException e) {
            if (!e.getValidationMessages().isEmpty()) {
                for (String message : e.getValidationMessages()) {
                    this.getLog().error((CharSequence)message);
                }
            }
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        catch (Exception e) {
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        return repository;
    }

    private ScmInfo loadInfosFromSettings(ScmProviderRepositoryWithHost repo) {
        Server server;
        ScmInfo info = new ScmInfo();
        String host = repo.getHost();
        int port = repo.getPort();
        if (port > 0) {
            host = host + ":" + port;
        }
        if ((server = this.settings.getServer(host)) != null) {
            info.setUsername(this.settings.getServer(host).getUsername());
            info.setPassword(this.settings.getServer(host).getPassword());
            info.setPrivateKey(this.settings.getServer(host).getPrivateKey());
            info.setPassphrase(this.settings.getServer(host).getPassphrase());
        }
        return info;
    }
}

